package com.zehong.system.service;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * @author geng
 * 政府监管平台信息
 */
public interface GovernmentSupervisionInfoService {

    /**
     * 获取市级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getCity(Map<String, Object> map) throws Exception;

    /**
     * 获取县级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getCounty(Map<String, Object> map) throws Exception;

    /**
     * 获取乡级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getTown(Map<String, Object> map) throws Exception;

    /**
     * 获取村级行政区
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getVillage(Map<String, Object> map) throws Exception;

    /**
     * 获取行业专家档案
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getProfessorInfo(Map<String,Object> map) throws Exception;

    /**
     * 获取专家行为档案
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getBehaviour (Map<String,Object> map) throws Exception;

    /**
     * 获取检查任务
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getTask (Map<String,Object> map) throws Exception;

    /**
     * 获取检查范围
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getScope (Map<String,Object> map) throws Exception;

    /**
     * 获取检查项
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getInspectList (Map<String,Object> map) throws Exception;

    /**
     * 获取调查项
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getSurveyList (Map<String,Object> map) throws Exception;


    /**
     * 获取抽查隐患
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getSpotHazard (Map<String,Object> map) throws Exception;

    /**
     * 获取隐患分类分级标准
     * @param map 入参
     * @return
     * @throws Exception
     */
    JSONObject getStandard (Map<String,Object> map) throws Exception;

}
