package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTrainPerson;
import org.apache.ibatis.annotations.Param;

/**
 * 燃气培训人员Mapper接口
 * 
 * @author zehong
 * @date 2023-04-22
 */
public interface TTrainPersonMapper 
{
    /**
     * 查询燃气培训人员
     * 
     * @param id 燃气培训人员ID
     * @return 燃气培训人员
     */
    public TTrainPerson selectTTrainPersonById(Long id);

    /**
     * 查询燃气培训人员列表
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 燃气培训人员集合
     */
    public List<TTrainPerson> selectTTrainPersonList(TTrainPerson tTrainPerson);

    /**
     * 新增燃气培训人员
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 结果
     */
    public int insertTTrainPerson(TTrainPerson tTrainPerson);

    /**
     * 修改燃气培训人员
     * 
     * @param tTrainPerson 燃气培训人员
     * @return 结果
     */
    public int updateTTrainPerson(TTrainPerson tTrainPerson);

    /**
     * 删除燃气培训人员
     * 
     * @param id 燃气培训人员ID
     * @return 结果
     */
    public int deleteTTrainPersonById(Long id);

    /**
     * 批量删除燃气培训人员
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrainPersonByIds(Long[] ids);

    /**
     * 批量插入培训人员
     * @param trainManageId
     * @param tTrainPeople
     */
    void batchInsertTTrainPerson(@Param("trainManageId") Long trainManageId, @Param("tTrainPeople")List<TTrainPerson> tTrainPeople);

    /**
     * 根据trainManageId删除培训人员
     * @param trainManageId
     * @return
     */
    int deleteTTrainPersonByTrainManageId(Long trainManageId);
}
