package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTrainManage;

/**
 * 培训管理Mapper接口
 * 
 * @author zehong
 * @date 2023-04-21
 */
public interface TTrainManageMapper 
{
    /**
     * 查询培训管理
     * 
     * @param trainManageId 培训管理ID
     * @return 培训管理
     */
    public TTrainManage selectTTrainManageById(Long trainManageId);

    /**
     * 查询培训管理列表
     * 
     * @param tTrainManage 培训管理
     * @return 培训管理集合
     */
    public List<TTrainManage> selectTTrainManageList(TTrainManage tTrainManage);

    /**
     * 新增培训管理
     * 
     * @param tTrainManage 培训管理
     * @return 结果
     */
    public int insertTTrainManage(TTrainManage tTrainManage);

    /**
     * 修改培训管理
     * 
     * @param tTrainManage 培训管理
     * @return 结果
     */
    public int updateTTrainManage(TTrainManage tTrainManage);

    /**
     * 删除培训管理
     * 
     * @param trainManageId 培训管理ID
     * @return 结果
     */
    public int deleteTTrainManageById(Long trainManageId);

    /**
     * 批量删除培训管理
     * 
     * @param trainManageIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrainManageByIds(Long[] trainManageIds);

    /**
     * 根据培训人员查询培训课程
     * @param trainPersonId 培训人员
     * @return
     */
    List<TTrainManage> getTrainInfoByPersonId(Long trainPersonId);
}
