package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTownLevelRegion;

/**
 * 乡级行政区Mapper接口
 * 
 * @author zehong
 * @date 2024-06-07
 */
public interface TTownLevelRegionMapper 
{
    /**
     * 查询乡级行政区
     * 
     * @param fId 乡级行政区ID
     * @return 乡级行政区
     */
    public TTownLevelRegion selectTTownLevelRegionById(Long fId);

    /**
     * 查询乡级行政区列表
     * 
     * @param tTownLevelRegion 乡级行政区
     * @return 乡级行政区集合
     */
    public List<TTownLevelRegion> selectTTownLevelRegionList(TTownLevelRegion tTownLevelRegion);

    /**
     * 新增乡级行政区
     * 
     * @param tTownLevelRegion 乡级行政区
     * @return 结果
     */
    public int insertTTownLevelRegion(TTownLevelRegion tTownLevelRegion);

    /**
     * 修改乡级行政区
     * 
     * @param tTownLevelRegion 乡级行政区
     * @return 结果
     */
    public int updateTTownLevelRegion(TTownLevelRegion tTownLevelRegion);

    /**
     * 删除乡级行政区
     * 
     * @param fId 乡级行政区ID
     * @return 结果
     */
    public int deleteTTownLevelRegionById(Long fId);

    /**
     * 批量删除乡级行政区
     * 
     * @param fIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTownLevelRegionByIds(Long[] fIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTTownLevelRegion(List<TTownLevelRegion> list);
}
