package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;
import com.zehong.system.domain.TSupBalUsgDay;

/**
 * 供需平衡-企业每日填报Mapper接口
 * 
 * @author zehong
 * @date 2024-06-25
 */
public interface TSupBalUsgDayMapper 
{
    /**
     * 查询供需平衡-企业每日填报
     * 
     * @param fRepUsgDayId 供需平衡-企业每日填报ID
     * @return 供需平衡-企业每日填报
     */
    public TSupBalUsgDay selectTSupBalUsgDayById(Long fRepUsgDayId);

    /**
     * 查询供需平衡-企业每日填报列表
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 供需平衡-企业每日填报集合
     */
    public List<TSupBalUsgDay> selectTSupBalUsgDayList(TSupBalUsgDay tSupBalUsgDay);

    /**
     * 新增供需平衡-企业每日填报
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 结果
     */
    public int insertTSupBalUsgDay(TSupBalUsgDay tSupBalUsgDay);

    /**
     * 修改供需平衡-企业每日填报
     * 
     * @param tSupBalUsgDay 供需平衡-企业每日填报
     * @return 结果
     */
    public int updateTSupBalUsgDay(TSupBalUsgDay tSupBalUsgDay);

    /**
     * 删除供需平衡-企业每日填报
     * 
     * @param fRepUsgDayId 供需平衡-企业每日填报ID
     * @return 结果
     */
    public int deleteTSupBalUsgDayById(Long fRepUsgDayId);

    /**
     * 批量删除供需平衡-企业每日填报
     * 
     * @param fRepUsgDayIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSupBalUsgDayByIds(Long[] fRepUsgDayIds);

    /**
     * 获取上报信息
     */
    TSupBalUsgDay getReportInfoByCompany(Map<String, String> param);
}
