package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.TSupBalGasSup;
import org.apache.ibatis.annotations.Param;
import org.springframework.security.core.parameters.P;

/**
 * 供需平衡-气量监管Mapper接口
 * 
 * @author zehong
 * @date 2024-06-15
 */
public interface TSupBalGasSupMapper 
{
    /**
     * 查询供需平衡-气量监管
     * 
     * @param fGasSupId 供需平衡-气量监管ID
     * @return 供需平衡-气量监管
     */
    public TSupBalGasSup selectTSupBalGasSupById(Long fGasSupId);

    /**
     * 查询供需平衡-气量监管列表
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 供需平衡-气量监管集合
     */
    public List<TSupBalGasSup> selectTSupBalGasSupList(TSupBalGasSup tSupBalGasSup);

    public List<Statistics> tSupBalGasSupStatistics(@Param("list") List<String> sevenDate, @Param("companyInfoId") String companyInfoId);

    /**
     * 新增供需平衡-气量监管
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 结果
     */
    public int insertTSupBalGasSup(TSupBalGasSup tSupBalGasSup);

    /**
     * 修改供需平衡-气量监管
     * 
     * @param tSupBalGasSup 供需平衡-气量监管
     * @return 结果
     */
    public int updateTSupBalGasSup(TSupBalGasSup tSupBalGasSup);

    /**
     * 删除供需平衡-气量监管
     * 
     * @param fGasSupId 供需平衡-气量监管ID
     * @return 结果
     */
    public int deleteTSupBalGasSupById(Long fGasSupId);

    /**
     * 批量删除供需平衡-气量监管
     * 
     * @param fGasSupIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSupBalGasSupByIds(Long[] fGasSupIds);

    /**
     * 获取上报信息
     */
    TSupBalGasSup getReportInfoByCompany(Map<String, String> param);
}
