package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TSafeEquipmentStandingBook;
import com.zehong.system.domain.form.TSafeEquipmentStandingBookForm;

/**
 * 用户加装安全装置台账Mapper接口
 * 
 * @author zehong
 * @date 2022-02-09
 */
public interface TSafeEquipmentStandingBookMapper 
{
    /**
     * 查询用户加装安全装置台账
     * 
     * @param safeEquipmentId 用户加装安全装置台账ID
     * @return 用户加装安全装置台账
     */
    public TSafeEquipmentStandingBook selectTSafeEquipmentStandingBookById(Long safeEquipmentId);

    /**
     * 查询用户加装安全装置台账列表
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 用户加装安全装置台账集合
     */
    public List<TSafeEquipmentStandingBook> selectTSafeEquipmentStandingBookList(TSafeEquipmentStandingBookForm tSafeEquipmentStandingBook);

    /**
     * 新增用户加装安全装置台账
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 结果
     */
    public int insertTSafeEquipmentStandingBook(TSafeEquipmentStandingBook tSafeEquipmentStandingBook);

    /**
     * 修改用户加装安全装置台账
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 结果
     */
    public int updateTSafeEquipmentStandingBook(TSafeEquipmentStandingBook tSafeEquipmentStandingBook);

    /**
     * 删除用户加装安全装置台账
     * 
     * @param safeEquipmentId 用户加装安全装置台账ID
     * @return 结果
     */
    public int deleteTSafeEquipmentStandingBookById(Long safeEquipmentId);

    /**
     * 批量删除用户加装安全装置台账
     * 
     * @param safeEquipmentIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSafeEquipmentStandingBookByIds(Long[] safeEquipmentIds);

    public List<Map<String,Object>> selectCountByYears();
    public List<Map<String,Object>> selectCountByUserType();
}
