package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.TLpgVehicleInfo;
import org.apache.ibatis.annotations.Param;

/**
 * 液化石油车辆信息Mapper接口
 * 
 * @author zehong
 * @date 2024-07-19
 */
public interface TLpgVehicleInfoMapper 
{
    /**
     * 查询液化石油车辆信息
     * 
     * @param vehicleId 液化石油车辆信息ID
     * @return 液化石油车辆信息
     */
    public TLpgVehicleInfo selectTLpgVehicleInfoById(Long vehicleId);

    /**
     * 查询液化石油车辆信息列表
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 液化石油车辆信息集合
     */
    public List<TLpgVehicleInfo> selectTLpgVehicleInfoList(TLpgVehicleInfo tLpgVehicleInfo);

    /**
     * 查询这个企业下 车牌号是否重复
     * @param carNums c
     * @param enterpriseId e
     * @return r
     */
    public List<TLpgVehicleInfo> queryByCarNumsAndEnterpriseId(@Param("carNums") List<String> carNums,@Param("enterpriseId") String enterpriseId);

    /**
     * 新增液化石油车辆信息
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 结果
     */
    public int insertTLpgVehicleInfo(TLpgVehicleInfo tLpgVehicleInfo);

    /**
     * 修改液化石油车辆信息
     * 
     * @param tLpgVehicleInfo 液化石油车辆信息
     * @return 结果
     */
    public int updateTLpgVehicleInfo(TLpgVehicleInfo tLpgVehicleInfo);

    /**
     * 删除液化石油车辆信息
     * 
     * @param vehicleId 液化石油车辆信息ID
     * @return 结果
     */
    public int deleteTLpgVehicleInfoById(Long vehicleId);

    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TLpgVehicleInfo> list);

    /**
     * 批量更新
     * @param list list
     * @return r
     */
    public int updateBatch(@Param("list") List<TLpgVehicleInfo> list);
    /**
     * 批量删除液化石油车辆信息
     * 
     * @param vehicleIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLpgVehicleInfoByIds(Long[] vehicleIds);
}
