package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.TLpgSafeCheckRecord;
import org.apache.ibatis.annotations.Param;

/**
 * 液化石油安检记录Mapper接口
 * 
 * @author zehong
 * @date 2024-07-22
 */
public interface TLpgSafeCheckRecordMapper 
{
    /**
     * 查询液化石油安检记录
     * 
     * @param safeCheckId 液化石油安检记录ID
     * @return 液化石油安检记录
     */
    public TLpgSafeCheckRecord selectTLpgSafeCheckRecordById(Long safeCheckId);

    /**
     * 查询液化石油安检记录列表
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 液化石油安检记录集合
     */
    public List<TLpgSafeCheckRecord> selectTLpgSafeCheckRecordList(TLpgSafeCheckRecord tLpgSafeCheckRecord);

    /**
     * 新增液化石油安检记录
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 结果
     */
    public int insertTLpgSafeCheckRecord(TLpgSafeCheckRecord tLpgSafeCheckRecord);

    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TLpgSafeCheckRecord> list);

    /**
     * 批量插入 包含图片
     * @param list list
     * @return r
     */
    public int insertBatchContainPic(@Param("list") List<TLpgSafeCheckRecord> list);
    /**
     * 修改液化石油安检记录
     * 
     * @param tLpgSafeCheckRecord 液化石油安检记录
     * @return 结果
     */
    public int updateTLpgSafeCheckRecord(TLpgSafeCheckRecord tLpgSafeCheckRecord);

    /**
     * 删除液化石油安检记录
     * 
     * @param safeCheckId 液化石油安检记录ID
     * @return 结果
     */
    public int deleteTLpgSafeCheckRecordById(Long safeCheckId);

    /**
     * 批量删除液化石油安检记录
     * 
     * @param safeCheckIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLpgSafeCheckRecordByIds(Long[] safeCheckIds);
}
