package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TLpgDeliveryRecord;
import com.zehong.system.domain.TYehuaqiUser;
import org.apache.ibatis.annotations.Param;

/**
 * 液化石油配送记录Mapper接口
 * 
 * @author zehong
 * @date 2024-07-22
 */
public interface TLpgDeliveryRecordMapper 
{
    /**
     * 查询液化石油配送记录
     * 
     * @param deliveryRecordId 液化石油配送记录ID
     * @return 液化石油配送记录
     */
    public TLpgDeliveryRecord selectTLpgDeliveryRecordById(Long deliveryRecordId);

    /**
     * 查询液化石油配送记录列表
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 液化石油配送记录集合
     */
    public List<TLpgDeliveryRecord> selectTLpgDeliveryRecordList(TLpgDeliveryRecord tLpgDeliveryRecord);

    /**
     * 根据气瓶条码查询配气记录
     * @param bottleCode r
     * @return r
     */
    public List<TLpgDeliveryRecord> queryAllByBottleCodeLimit2(String bottleCode);

    /**
     * 新增液化石油配送记录
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 结果
     */
    public int insertTLpgDeliveryRecord(TLpgDeliveryRecord tLpgDeliveryRecord);

    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TLpgDeliveryRecord> list);
    /**
     * 修改液化石油配送记录
     * 
     * @param tLpgDeliveryRecord 液化石油配送记录
     * @return 结果
     */
    public int updateTLpgDeliveryRecord(TLpgDeliveryRecord tLpgDeliveryRecord);

    /**
     * 删除液化石油配送记录
     * 
     * @param deliveryRecordId 液化石油配送记录ID
     * @return 结果
     */
    public int deleteTLpgDeliveryRecordById(Long deliveryRecordId);

    /**
     * 批量删除液化石油配送记录
     * 
     * @param deliveryRecordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLpgDeliveryRecordByIds(Long[] deliveryRecordIds);
}
