package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInsInsListInfor;

/**
 * 监督检查-获取检查项Mapper接口
 * 
 * @author zehong
 * @date 2024-05-17
 */
public interface TInsInsListInforMapper 
{
    /**
     * 查询监督检查-获取检查项
     * 
     * @param fInsInsListInforId 监督检查-获取检查项ID
     * @return 监督检查-获取检查项
     */
    public TInsInsListInfor selectTInsInsListInforById(Long fInsInsListInforId);

    /**
     * 查询监督检查-获取检查项列表
     * 
     * @param tInsInsListInfor 监督检查-获取检查项
     * @return 监督检查-获取检查项集合
     */
    public List<TInsInsListInfor> selectTInsInsListInforList(TInsInsListInfor tInsInsListInfor);

    /**
     * 新增监督检查-获取检查项
     * 
     * @param tInsInsListInfor 监督检查-获取检查项
     * @return 结果
     */
    public int insertTInsInsListInfor(TInsInsListInfor tInsInsListInfor);

    /**
     * 修改监督检查-获取检查项
     * 
     * @param tInsInsListInfor 监督检查-获取检查项
     * @return 结果
     */
    public int updateTInsInsListInfor(TInsInsListInfor tInsInsListInfor);

    /**
     * 删除监督检查-获取检查项
     * 
     * @param fInsInsListInforId 监督检查-获取检查项ID
     * @return 结果
     */
    public int deleteTInsInsListInforById(Long fInsInsListInforId);

    /**
     * 批量删除监督检查-获取检查项
     * 
     * @param fInsInsListInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInsInsListInforByIds(Long[] fInsInsListInforIds);

    /**
     * 批量插入
     * @param list 批量数据
     * @return
     */
    int batchInsertTInsInsListInfor(List<TInsInsListInfor> list);
}
