package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.TGasuserSafetyDeviceInfo;
import org.apache.ibatis.annotations.Param;

/**
 * 用户管理-燃气用户-安全装置加装维护Mapper接口
 * 
 * @author zehong
 * @date 2024-08-27
 */
public interface TGasuserSafetyDeviceInfoMapper 
{
    /**
     * 查询用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceId 用户管理-燃气用户-安全装置加装维护ID
     * @return 用户管理-燃气用户-安全装置加装维护
     */
    public TGasuserSafetyDeviceInfo selectTGasuserSafetyDeviceInfoById(Long gasUserSafetyDeviceId);

    /**
     * 查询用户管理-燃气用户-安全装置加装维护列表
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 用户管理-燃气用户-安全装置加装维护集合
     */
    public List<TGasuserSafetyDeviceInfo> selectTGasuserSafetyDeviceInfoList(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);

    /**
     * 查询没有被关联的数据
     * @param gasuserSafetyDeviceInfo g
     * @return r
     */
    public List<TGasuserSafetyDeviceInfo> queryNoSelectSafeDeviceInfoList(TGasuserSafetyDeviceInfo gasuserSafetyDeviceInfo);

    /**
     * 新增用户管理-燃气用户-安全装置加装维护
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 结果
     */
    public int insertTGasuserSafetyDeviceInfo(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);


    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TGasuserSafetyDeviceInfo> list);

    /**
     * 修改用户管理-燃气用户-安全装置加装维护
     * 
     * @param tGasuserSafetyDeviceInfo 用户管理-燃气用户-安全装置加装维护
     * @return 结果
     */
    public int updateTGasuserSafetyDeviceInfo(TGasuserSafetyDeviceInfo tGasuserSafetyDeviceInfo);

    /**
     * 删除用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceId 用户管理-燃气用户-安全装置加装维护ID
     * @return 结果
     */
    public int deleteTGasuserSafetyDeviceInfoById(Long gasUserSafetyDeviceId);

    /**
     * 根据 userid删除 数据
     * @param userId user
     * @return r
     */
    public void deleteTGasuserSafetyDeviceInfoByUserId(Long userId);

    /**
     * 批量删除用户管理-燃气用户-安全装置加装维护
     * 
     * @param gasUserSafetyDeviceIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTGasuserSafetyDeviceInfoByIds(Long[] gasUserSafetyDeviceIds);

    /**
     * 逻辑删除
     * @param gasUserSafetyDeviceIds gas
     * @return r
     */
    public int deleteSafetyDeviceListInfo(Long[] gasUserSafetyDeviceIds);

    public int deleteSafetyDeviceInfo(Long deviceId);

    public int deleteBatchSafetyDeviceByUserIds(@Param("userIds") List<Long> userIds);

    List<TGasuserSafetyDeviceInfo> selectSafetyDeviceDetailInfoList(Long userId);

    /**
     * 将关联设备信息与设备进行绑定
     * @param gettDeviceInfoS
     */
    void updatetRelationSafetyDeviceInfo(@Param("gettDeviceInfoS")List<TGasuserSafetyDeviceInfo> gettDeviceInfoS,
                                         @Param("id") Long id);
}
