package com.zehong.system.mapper;

import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TDetectorUserCount;
import com.zehong.system.domain.dto.UserLinkGasBottleIdDTO;
import com.zehong.system.domain.dto.UserLinkGasBottleTitleDTO;
import com.zehong.system.domain.vo.TDetectorUserInspectVo;
import com.zehong.system.domain.vo.TDetectorUserVO;
import com.zehong.system.domain.vo.TDetectorUserVillageSafetyDeviceInfoVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 燃气用户Mapper接口
 *
 * @author zehong
 * @date 2022-02-07
 */
public interface TDetectorUserMapper
{
    /**
     * 查询燃气用户
     *
     * @param userId 燃气用户ID
     * @return 燃气用户
     */
    public TDetectorUser selectTDetectorUserById(Long userId);

    /**
     * 查询燃气用户统计信息
     *
     * @return 燃气用户
     */
    public List<TDetectorUserVO> countTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 查询 带有 设备 村庄的 燃气用户数据 只是居民用户
     * @param tDetectorUser t
     * @return l
     */
    List<Map<String,Object>> queryDuserVilSafDevInfoOnlyResidents(TDetectorUser tDetectorUser);

    List<TDetectorUserVillageSafetyDeviceInfoVo> queryDuserVilSafDevInfoOnlyResidentsInit(TDetectorUser tDetectorUser);

    /**
     * 查询 带有 设备 村庄的 燃气用户数据
     * @param tDetectorUser t
     * @return l
     */
    List<TDetectorUserVillageSafetyDeviceInfoVo> queryDuserVilSafDevInfo(TDetectorUser tDetectorUser);

    /**
     * 根据村庄查询 用户 关联 气瓶数量
     * @param villageIds v
     * @return r
     */
    List<UserLinkGasBottleIdDTO> queryUserIdLinkGasBottleIdByVillageIds(@Param("villageIds") List<Long> villageIds);

    /**
     * 根据村庄查询 用户 关联 气瓶信息
     * @param villageIds v
     * @return r
     */
    List<UserLinkGasBottleTitleDTO> queryUserIdLinkGasBottleTitleByVillageIds(@Param("villageIds") List<Long> villageIds);
    /**
     * 查询燃气用户统计信息大屏界面 使用massMarks标注的方式
     * @param tDetectorUser
     * @return
     */
    public List<TDetectorUserVO> countTDetectorUserForMassMarks(TDetectorUser tDetectorUser);

    /**
     * 查询探测器报警用户
     *
     * @return map
     */
    public List<Map> getDetectorUserAlarmList();

    /**
     * 泽宏云推送查询燃气用户
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户
     */
    public List<TDetectorUser> selectTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 查询燃气用户列表
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TDetectorUser> selectTDetectorUserList(TDetectorUser tDetectorUser);
    /**
     * 查询燃气用户列表 - 导出使用
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TDetectorUser> selectForExportTDetectorUserList(TDetectorUser tDetectorUser);

    /**
     * 查询燃气用户列表-new 有 居住区了
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TDetectorUser> newSelectTDetectorUserList(TDetectorUser tDetectorUser);

    public List<TDetectorUser> queryErrorDetectorUserList(@Param("depId") String depId,@Param("gasType") String gasType);
    /**
     * 根据 userOwnId list 和 enterpriseId 查询数据
     * @param userOwnIds userOwnId list
     * @param enterpriseId enterpriseId
     * @return r
     */
    public List<TDetectorUser> queryByUserOwnIdAndEnterpriseIdForThirdParty(@Param("userOwnIds") List<String> userOwnIds,@Param("enterpriseId") String enterpriseId);
    /**
     * 根据userOwnIds 和  enterpriseId 查询数据
     * @param userOwnIds u
     * @param enterpriseId e
     * @return r
     */
    public List<TDetectorUser> queryByUserOwnIdsAndEnterpriseId(@Param("userOwnIds") List<String> userOwnIds, @Param("enterpriseId") String enterpriseId);

    public List<TDetectorUser> selectTDetectorListstatus(TDetectorUser tDetectorUser);

    /**
     * 新增燃气用户
     *
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    public int insertTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 提供给第三方接口调用时的批量插入
     * @param tYehuaqiUsers r
     * @return r
     */
    public int insertBatchForThirdParty(@Param("list") List<TDetectorUser> tYehuaqiUsers);

    /**
     * 批量增加
     * @param list list
     * @return r
     */
    public int insertBatch(@Param("list") List<TDetectorUser> list);

    /**
     * 批量修改
     * @param list l
     * @return r
     */
    public int updateBatch(@Param("list") List<TDetectorUser> list);


    /**
     * 修改燃气用户
     *
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    public int updateTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 删除燃气用户
     *
     * @param userId 燃气用户ID
     * @return 结果
     */
    public int deleteTDetectorUserById(Long userId);

    /**
     * 批量删除燃气用户
     *
     * @param userIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDetectorUserByIds(Long[] userIds);

    /**
     * 查询用户数量
     * @return
     */
    public  Map<String,Object> selectUserNum();

    /**
     * 查询用户统计信息
     * @return
     */
    TDetectorUserCount userStatistics(String id);

    /**
     * 获取用户安检信息
     * @param inspectVo
     * @return
     */
    List<TDetectorUserInspectVo> getDetectorUserInspectInfo(TDetectorUserInspectVo inspectVo);


    /**
     * 根据企业id 统计错误数量
     * @param beyondEnterpriseId id
     * @return r
     */
    public int countByBeyondEnterpriseId(@Param("beyondEnterpriseId") String beyondEnterpriseId,
                                         @Param("gasType") String gasType);


    /**
     * 根据企业id 清除错误数量
     * @param beyondEnterpriseId id
     * @return r
     */
    public int clearByBeyondEnterpriseId(@Param("beyondEnterpriseId") String beyondEnterpriseId,
                                         @Param("gasType") String gasType);

}
