package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDetectorUserError;
import org.apache.ibatis.annotations.Param;

/**
 * 燃气用户错误导入记录Mapper接口
 * 
 * @author zehong
 * @date 2024-08-30
 */
public interface TDetectorUserErrorMapper 
{
    /**
     * 查询燃气用户错误导入记录
     * 
     * @param userId 燃气用户错误导入记录ID
     * @return 燃气用户错误导入记录
     */
    public TDetectorUserError selectTDetectorUserErrorById(Long userId);

    /**
     * 查询燃气用户错误导入记录列表
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 燃气用户错误导入记录集合
     */
    public List<TDetectorUserError> selectTDetectorUserErrorList(TDetectorUserError tDetectorUserError);

    /**
     * 新增燃气用户错误导入记录
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 结果
     */
    public int insertTDetectorUserError(TDetectorUserError tDetectorUserError);

    public int insertBatch(@Param("list") List<TDetectorUserError> list);

    /**
     * 修改燃气用户错误导入记录
     * 
     * @param tDetectorUserError 燃气用户错误导入记录
     * @return 结果
     */
    public int updateTDetectorUserError(TDetectorUserError tDetectorUserError);

    /**
     * 删除燃气用户错误导入记录
     * 
     * @param userId 燃气用户错误导入记录ID
     * @return 结果
     */
    public int deleteTDetectorUserErrorById(Long userId);

    /**
     * 批量删除燃气用户错误导入记录
     * 
     * @param userIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDetectorUserErrorByIds(Long[] userIds);

    /**
     * 根据企业id 统计错误数量
     * @param beyondEnterpriseId id
     * @return r
     */
    public int countByBeyondEnterpriseId(String beyondEnterpriseId);


    /**
     * 根据企业id 清除错误数量
     * @param beyondEnterpriseId id
     * @return r
     */
    public int clearByBeyondEnterpriseId(String beyondEnterpriseId);
}
