package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.FProBehInfor;

/**
 * 行业专家库-专家行为申报Mapper接口
 * 
 * @author zehong
 * @date 2024-05-09
 */
public interface FProBehInforMapper 
{
    /**
     * 查询行业专家库-专家行为申报
     * 
     * @param fProBehInforId 行业专家库-专家行为申报ID
     * @return 行业专家库-专家行为申报
     */
    public FProBehInfor selectFProBehInforById(Long fProBehInforId);

    /**
     * 查询行业专家库-专家行为申报列表
     * 
     * @param fProBehInfor 行业专家库-专家行为申报
     * @return 行业专家库-专家行为申报集合
     */
    public List<FProBehInfor> selectFProBehInforList(FProBehInfor fProBehInfor);

    /**
     * 新增行业专家库-专家行为申报
     * 
     * @param fProBehInfor 行业专家库-专家行为申报
     * @return 结果
     */
    public int insertFProBehInfor(FProBehInfor fProBehInfor);

    /**
     * 修改行业专家库-专家行为申报
     * 
     * @param fProBehInfor 行业专家库-专家行为申报
     * @return 结果
     */
    public int updateFProBehInfor(FProBehInfor fProBehInfor);

    /**
     * 删除行业专家库-专家行为申报
     * 
     * @param fProBehInforId 行业专家库-专家行为申报ID
     * @return 结果
     */
    public int deleteFProBehInforById(Long fProBehInforId);

    /**
     * 批量删除行业专家库-专家行为申报
     * 
     * @param fProBehInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteFProBehInforByIds(Long[] fProBehInforIds);
}
