package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;

import java.util.Date;

/**
 * 液化石油安检记录 t_lpg_safe_check_record
 *
 * @author zehong
 * @date 2024-09-11
 */
public class TLpgSafeCheckRecordImportVo {

    /** 储配站 */
    @Excel(name = "储配站")
    private String stationName;

    /** 用户账号 */
    @Excel(name = "用户自有编号")
    private String userOwnId;

    /** 用户名 */
    @Excel(name = "用户名")
    private String gasUser;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String telNum;

    /** 用户地址 */
    @Excel(name = "用户地址")
    private String gasUserAddress;

    /** 0.居民 1.非居民 */
    @Excel(name = "用户类型",readConverterExp = "0=居民,1=非居民",combo = "居民,非居民")
    private String gasUserType;

    /** 安检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "安检时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date safeCheckDate;

    /** 安检人 */
    @Excel(name = "安检人")
    private String safeCheckPerson;

    /** 气瓶数量 */
    @Excel(name = "气瓶数量")
    private Integer bottleNum;

    /** 入户状态：0.正常入户 1.拒绝安检 */
    @Excel(name = "入户状态",readConverterExp = "0=正常入户,1=拒绝安检",combo = "正常入户,拒绝安检")
    private String checkInStatus;

    /** 燃气灶具检查情况:0.合格 1.无3C认证 2.无熄火保护装置 */
    @Excel(name = "燃气灶具检查情况",readConverterExp = "0=合格,1=无3C认证,2=无熄火保护装置",combo = "合格,无3C认证,无熄火保护装置",width = 25)
    private String stoveCheckStatus;

    /** 连接软管检查情况:0.合格 1.普通橡胶软管 2.三通连接软管 3.长度超过两米且未使用硬质钢管链接 4.穿越墙体、门窗顶棚和地面 */
    @Excel(name = "连接软管检查情况",readConverterExp = "0=合格,1=普通橡胶软管,2=三通连接软管,3=长度超过两米且未使用硬质钢管链接,4=穿越墙体、门窗顶棚和地面",combo = "合格,普通橡胶软管,三通连接软管,长度超过两米且未使用硬质钢管链接,穿越墙体、门窗顶棚和地面",width = 25)
    private String hoseCheckStatus;

    /** 减压阀检查情况:0.合格 1.可调节 2.五自闭功能 */
    @Excel(name = "减压阀检查情况",readConverterExp = "0=合格,1=可调节,2=五自闭功能",combo = "合格,可调节,五自闭功能",width = 25)
    private String valveCheckStatus;

    /** 液化气钢瓶检查情况:0.合格 1.部分有码且可追溯 2.有码但不可追溯 3.钢瓶无码 */
    @Excel(name = "液化气钢瓶检查情况",readConverterExp = "0=合格,1=部分有码且可追溯,2=有码但不可追溯,3=钢瓶无码",combo = "合格,部分有码且可追溯,有码但不可追溯,钢瓶无码",width = 25)
    private String bottleCheckStatus;

    /** 报警器加电磁切断阀检查情况:0.合格 1.有但未使用 2.有但未实现联动 3.无 4.非液化气专用报警器 5.安装位置大于0.3米 */
    @Excel(name = "报警器加电磁切断阀检查情况",readConverterExp = "0=合格,1=有但未使用,2=有但未实现联动,3=无,4=非液化气专用报警器,5=安装位置大于0.3米",combo = "合格,有但未使用,有但未实现联动,无,非液化气专用报警器,安装位置大于0.3米",width = 25)
    private String alarmCheckStatus;

    /** 用气场所检查情况:0.合格 1.高层建筑（裙房） 2.地下（半地下）室 3.车库或半地下车库 4.通风不良的场所 5.50公斤钢瓶超过两只或15公斤钢瓶超过七只未设置独立的气瓶间 */
    @Excel(name = "用气场所检查情况", readConverterExp = "0=合格,1=高层建筑（裙房）,2=地下（半地下）室,3=车库或半地下车库,4=通风不良的场所 5=50公斤钢瓶超过两只或15公斤钢瓶超过七只未设置独立的气瓶间",combo = "合格,高层建筑（裙房）,地下（半地下）室,车库或半地下车库,通风不良的场所,50公斤钢瓶超过两只或15公斤钢瓶超过七只未设置独立的气瓶间",width = 25)
    private String placeCheckStatus;

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getUserOwnId() {
        return userOwnId;
    }

    public void setUserOwnId(String userOwnId) {
        this.userOwnId = userOwnId;
    }

    public String getGasUser() {
        return gasUser;
    }

    public void setGasUser(String gasUser) {
        this.gasUser = gasUser;
    }

    public String getTelNum() {
        return telNum;
    }

    public void setTelNum(String telNum) {
        this.telNum = telNum;
    }

    public String getGasUserAddress() {
        return gasUserAddress;
    }

    public void setGasUserAddress(String gasUserAddress) {
        this.gasUserAddress = gasUserAddress;
    }

    public String getGasUserType() {
        return gasUserType;
    }

    public void setGasUserType(String gasUserType) {
        this.gasUserType = gasUserType;
    }

    public Date getSafeCheckDate() {
        return safeCheckDate;
    }

    public void setSafeCheckDate(Date safeCheckDate) {
        this.safeCheckDate = safeCheckDate;
    }

    public String getSafeCheckPerson() {
        return safeCheckPerson;
    }

    public void setSafeCheckPerson(String safeCheckPerson) {
        this.safeCheckPerson = safeCheckPerson;
    }

    public Integer getBottleNum() {
        return bottleNum;
    }

    public void setBottleNum(Integer bottleNum) {
        this.bottleNum = bottleNum;
    }

    public String getCheckInStatus() {
        return checkInStatus;
    }

    public void setCheckInStatus(String checkInStatus) {
        this.checkInStatus = checkInStatus;
    }

    public String getStoveCheckStatus() {
        return stoveCheckStatus;
    }

    public void setStoveCheckStatus(String stoveCheckStatus) {
        this.stoveCheckStatus = stoveCheckStatus;
    }

    public String getHoseCheckStatus() {
        return hoseCheckStatus;
    }

    public void setHoseCheckStatus(String hoseCheckStatus) {
        this.hoseCheckStatus = hoseCheckStatus;
    }

    public String getValveCheckStatus() {
        return valveCheckStatus;
    }

    public void setValveCheckStatus(String valveCheckStatus) {
        this.valveCheckStatus = valveCheckStatus;
    }

    public String getBottleCheckStatus() {
        return bottleCheckStatus;
    }

    public void setBottleCheckStatus(String bottleCheckStatus) {
        this.bottleCheckStatus = bottleCheckStatus;
    }

    public String getAlarmCheckStatus() {
        return alarmCheckStatus;
    }

    public void setAlarmCheckStatus(String alarmCheckStatus) {
        this.alarmCheckStatus = alarmCheckStatus;
    }

    public String getPlaceCheckStatus() {
        return placeCheckStatus;
    }

    public void setPlaceCheckStatus(String placeCheckStatus) {
        this.placeCheckStatus = placeCheckStatus;
    }
}
