package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 燃气用户入户安检信息
 *
 * @author zehong
 * @date 2022-02-07
 */
public class TDetectorUserInspectVo {

    /** 用户id */
    private Long userId;

    /** 用户账号 */
    private String username;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String nickName;

    /** 权属单位 */
    private String beyondEnterpriseId;

    /** 用户类型（1居民用户，2商业用户，3工业用户） */
    @Excel(name = "用户类型")
    private String userType;

    @Excel(name = "燃气类型",dictType = "gas_type")
    private String gasType;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /**
     * 所属企业名称
     */
    @Excel(name = "所属单位")
    private String beyondEnterpriseName;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 联系人 */
    @Excel(name = "表号")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /**
     * 是否入户安检 0否 1是
     */
    @Excel(name="是否安检",readConverterExp = "0=否,1=是")
    private String isInspect;

    /**
     * 安检人
     */
    @Excel(name="最近安检人")
    private String inspector;

    /**
     * 安检时间
     */
    @Excel(name="最近安检时间",dateFormat = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectDate;

    /**
     * 入户安检开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectBeginTime;

    /**
     * 入户安检结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectEndTime;

    /**
     * 任务主键
     */
    private Long taskId;

    public String getBeyondEnterpriseName() {
        return beyondEnterpriseName;
    }

    public void setBeyondEnterpriseName(String beyondEnterpriseName) {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }


    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public Long getUserId()
    {
        return userId;
    }
    public void setUsername(String username)
    {
        this.username = username;
    }

    public String getUsername()
    {
        return username;
    }
    public void setNickName(String nickName)
    {
        this.nickName = nickName;
    }

    public String getNickName()
    {
        return nickName;
    }
    public void setUserType(String userType)
    {
        this.userType = userType;
    }

    public String getUserType()
    {
        return userType;
    }
    public void setAddress(String address)
    {
        this.address = address;
    }

    public String getAddress()
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setLinkman(String linkman)
    {
        this.linkman = linkman;
    }

    public String getLinkman()
    {
        return linkman;
    }
    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhone()
    {
        return phone;
    }

    public String getIsInspect() {
        return isInspect;
    }

    public void setIsInspect(String isInspect) {
        this.isInspect = isInspect;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public Date getInspectDate() {
        return inspectDate;
    }

    public void setInspectDate(Date inspectDate) {
        this.inspectDate = inspectDate;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Date getInspectBeginTime() {
        return inspectBeginTime;
    }

    public void setInspectBeginTime(Date inspectBeginTime) {
        this.inspectBeginTime = inspectBeginTime;
    }

    public Date getInspectEndTime() {
        return inspectEndTime;
    }

    public void setInspectEndTime(Date inspectEndTime) {
        this.inspectEndTime = inspectEndTime;
    }

    public String getGasType() {
        return gasType;
    }

    public void setGasType(String gasType) {
        this.gasType = gasType;
    }

    @Override
    public String toString() {
        return "TDetectorUser{" +
                "userId=" + userId +
                ", username='" + username + '\'' +
                ", nickName='" + nickName + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", userType='" + userType + '\'' +
                ", address='" + address + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", linkman='" + linkman + '\'' +
                ", phone='" + phone + '\'' +
                '}';
    }
}
