package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 【请填写功能名称】对象 t_yehuaqi_device
 * 
 * @author zehong
 * @date 2022-09-14
 */
public class TYehuaqiDevice extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备id */
    private Long detectorId;

    /** 企业id */
    @Excel(name = "企业id")
    private Long enterpriseId;

    /** 所属用户id */
    @Excel(name = "所属用户id")
    private Long userId;

    /** 所属设备id（阀门井、调压箱） */
    @Excel(name = "所属设备id", readConverterExp = "阀=门井、调压箱")
    private Long deviceId;

    /** 所属场站id */
    @Excel(name = "所属场站id")
    private Long siteStationId;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String detectorName;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String detectorCode;

    /** 设备地址 */
    @Excel(name = "设备地址")
    private String detectorAddr;

    /** 设备类型（1家用报警器，2工业报警器） */
    @Excel(name = "设备类型", readConverterExp = "1=家用报警器，2工业报警器")
    private String detectorType;

    /** 检测介质（1甲烷，2氨气，3一氧化碳，4可燃气体，5有毒气体） */
    @Excel(name = "检测介质", readConverterExp = "1=甲烷，2氨气，3一氧化碳，4可燃气体，5有毒气体")
    private String medium;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 物联网编号 */
    @Excel(name = "物联网编号")
    private String iotNo;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 最后巡检时间 */
    @Excel(name = "最后巡检时间")
    private String alarmTime;

    /** 设备状态，0正常，1故障（掉线） */
    @Excel(name = "设备状态，0正常，1故障", readConverterExp = "掉=线")
    private String detectorStatus;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setDetectorId(Long detectorId) 
    {
        this.detectorId = detectorId;
    }

    public Long getDetectorId() 
    {
        return detectorId;
    }
    public void setEnterpriseId(Long enterpriseId) 
    {
        this.enterpriseId = enterpriseId;
    }

    public Long getEnterpriseId() 
    {
        return enterpriseId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }
    public void setSiteStationId(Long siteStationId) 
    {
        this.siteStationId = siteStationId;
    }

    public Long getSiteStationId() 
    {
        return siteStationId;
    }
    public void setDetectorName(String detectorName) 
    {
        this.detectorName = detectorName;
    }

    public String getDetectorName() 
    {
        return detectorName;
    }
    public void setDetectorCode(String detectorCode) 
    {
        this.detectorCode = detectorCode;
    }

    public String getDetectorCode() 
    {
        return detectorCode;
    }
    public void setDetectorAddr(String detectorAddr) 
    {
        this.detectorAddr = detectorAddr;
    }

    public String getDetectorAddr() 
    {
        return detectorAddr;
    }
    public void setDetectorType(String detectorType) 
    {
        this.detectorType = detectorType;
    }

    public String getDetectorType() 
    {
        return detectorType;
    }
    public void setMedium(String medium) 
    {
        this.medium = medium;
    }

    public String getMedium() 
    {
        return medium;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setIotNo(String iotNo) 
    {
        this.iotNo = iotNo;
    }

    public String getIotNo() 
    {
        return iotNo;
    }
    public void setLinkman(String linkman) 
    {
        this.linkman = linkman;
    }

    public String getLinkman() 
    {
        return linkman;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setAlarmTime(String alarmTime) 
    {
        this.alarmTime = alarmTime;
    }

    public String getAlarmTime() 
    {
        return alarmTime;
    }
    public void setDetectorStatus(String detectorStatus) 
    {
        this.detectorStatus = detectorStatus;
    }

    public String getDetectorStatus() 
    {
        return detectorStatus;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("detectorId", getDetectorId())
            .append("enterpriseId", getEnterpriseId())
            .append("userId", getUserId())
            .append("deviceId", getDeviceId())
            .append("siteStationId", getSiteStationId())
            .append("detectorName", getDetectorName())
            .append("detectorCode", getDetectorCode())
            .append("detectorAddr", getDetectorAddr())
            .append("detectorType", getDetectorType())
            .append("medium", getMedium())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("iotNo", getIotNo())
            .append("linkman", getLinkman())
            .append("phone", getPhone())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("alarmTime", getAlarmTime())
            .append("detectorStatus", getDetectorStatus())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
