package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡线任务对象 t_work_task_patrol
 * 
 * @author zehong
 * @date 2023-09-15
 */
public class TWorkTaskPatrol extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long patrolId;

    /** 任务id */
    @Excel(name = "任务id")
    private Long taskId;

    /** 巡线人id */
    @Excel(name = "巡线人id")
    private Long memberId;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private String memberName;

    private String taskTitle;

    private Long createEnterpriseId;

    private Integer taskStatus;

    private List<TUserLocation> locationList;

    public List<TUserLocation> getLocationList() {
        return locationList;
    }

    public void setLocationList(List<TUserLocation> locationList) {
        this.locationList = locationList;
    }

    public void setPatrolId(Long patrolId)
    {
        this.patrolId = patrolId;
    }

    public Long getPatrolId() 
    {
        return patrolId;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setMemberId(Long memberId) 
    {
        this.memberId = memberId;
    }

    public Long getMemberId() 
    {
        return memberId;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("patrolId", getPatrolId())
            .append("taskId", getTaskId())
            .append("memberId", getMemberId())
            .append("createTime", getCreateTime())
            .append("endTime", getEndTime())
            .toString();
    }
}
