package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 村级行政区对象 t_village_level_region
 * 
 * @author zehong
 * @date 2024-06-07
 */
public class TVillageLevelRegion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /**  村级行政区 ID，表主键，非自增 */
    private Long fId;

    /** 所属乡镇 id */
    @Excel(name = "所属乡镇 id")
    private Long fTownId;

    /** 村行政区划编码 */
    @Excel(name = "村行政区划编码")
    private String fVillageCode;

    /**  村名称 */
    @Excel(name = " 村名称")
    private String fName;

    /** 是否气代煤村，0 否，1 是 */
    @Excel(name = "是否气代煤村，0 否，1 是")
    private String fIsSd;

    public void setfId(Long fId) 
    {
        this.fId = fId;
    }

    public Long getfId() 
    {
        return fId;
    }
    public void setfTownId(Long fTownId) 
    {
        this.fTownId = fTownId;
    }

    public Long getfTownId() 
    {
        return fTownId;
    }
    public void setfVillageCode(String fVillageCode) 
    {
        this.fVillageCode = fVillageCode;
    }

    public String getfVillageCode() 
    {
        return fVillageCode;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfIsSd(String fIsSd) 
    {
        this.fIsSd = fIsSd;
    }

    public String getfIsSd() 
    {
        return fIsSd;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fId", getfId())
            .append("fTownId", getfTownId())
            .append("fVillageCode", getfVillageCode())
            .append("fName", getfName())
            .append("fIsSd", getfIsSd())
            .toString();
    }
}
