package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Objects;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 基本信息维护-用户管理-居住区(村庄)对象 t_user_manage_village
 * 
 * @author zehong
 * @date 2024-08-27
 */
public class TUserManageVillage extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fVillageId;


    /** 燃气企业 */
    private String beyondEnterpriseId;

    /**
     * 燃气企业名称 导出用
     */
    @Excel(name = "所属企业")
    private String beyondEnterpriseName;

    /** 居住区(村庄)名称 */
    @Excel(name = "居住区(村庄)名称")
    private String fVillageName;

    /** 所在县（市、区）ID */
    private Long fRegion;

    /** 所在县（市、区）ID 名称，导出使用 */
    @Excel(name = "所在县（市、区）")
    private String fRegionName;

    /** 居民总户数 */
    @Excel(name = "居民总户数")
    private Long fTotalNumHouse;

    /** 管道燃气用户数（开通数） */
    @Excel(name = "管道燃气用户数")
    private Long fPipeGasUsers;

    /** 瓶装燃气用户数 */
    @Excel(name = "瓶装燃气用户数")
    private Long fBottledGasUsers;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 备注 */
    private String remarks;

    /**
     * 县（市、区）行政区划编码 第三方接口对接时使用
     */
    private String countyCode;

    public void setfVillageId(Long fVillageId) 
    {
        this.fVillageId = fVillageId;
    }

    public Long getfVillageId() 
    {
        return fVillageId;
    }
    public void setfVillageName(String fVillageName) 
    {
        this.fVillageName = fVillageName;
    }

    public String getfVillageName() 
    {
        return fVillageName;
    }
    public void setfRegion(Long fRegion) 
    {
        this.fRegion = fRegion;
    }

    public Long getfRegion() 
    {
        return fRegion;
    }
    public void setfTotalNumHouse(Long fTotalNumHouse) 
    {
        this.fTotalNumHouse = fTotalNumHouse;
    }

    public Long getfTotalNumHouse() 
    {
        return fTotalNumHouse;
    }
    public void setfPipeGasUsers(Long fPipeGasUsers) 
    {
        this.fPipeGasUsers = fPipeGasUsers;
    }

    public Long getfPipeGasUsers() 
    {
        return fPipeGasUsers;
    }
    public void setfBottledGasUsers(Long fBottledGasUsers) 
    {
        this.fBottledGasUsers = fBottledGasUsers;
    }

    public Long getfBottledGasUsers() 
    {
        return fBottledGasUsers;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getfRegionName() {
        return fRegionName;
    }

    public void setfRegionName(String fRegionName) {
        this.fRegionName = fRegionName;
    }

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseName() {
        return beyondEnterpriseName;
    }

    public void setBeyondEnterpriseName(String beyondEnterpriseName) {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        TUserManageVillage tUserManageVillage = (TUserManageVillage) obj;
        return Objects.equals(fVillageName,tUserManageVillage.getfVillageName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(fVillageName);
    }
    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fVillageId", getfVillageId())
            .append("fVillageName", getfVillageName())
            .append("fRegion", getfRegion())
            .append("fTotalNumHouse", getfTotalNumHouse())
            .append("fPipeGasUsers", getfPipeGasUsers())
            .append("fBottledGasUsers", getfBottledGasUsers())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("countyCoude", getCountyCode())
            .append("remarks", getRemarks())
            .toString();
    }
}
