package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 巡检签到对象 t_patrol_check_in
 * 
 * @author zehong
 * @date 2023-03-10
 */
public class TPatrolCheckIn extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 签到id */
    private Long checkInId;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 照片地址 */
    @Excel(name = "照片地址")
    private String photoUrl;

    /** 描述 */
    @Excel(name = "描述")
    private String patrolDescribe;

    /** 上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "上报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportTime;

    /** 上报人 */
    @Excel(name = "上报人")
    private Long reportPerson;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    private String personName;

    private Date reportTimeBegin;

    private Date reportTimeEnd;


    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public Date getReportTimeBegin() {
        return reportTimeBegin;
    }

    public void setReportTimeBegin(Date reportTimeBegin) {
        this.reportTimeBegin = reportTimeBegin;
    }

    public Date getReportTimeEnd() {
        return reportTimeEnd;
    }

    public void setReportTimeEnd(Date reportTimeEnd) {
        this.reportTimeEnd = reportTimeEnd;
    }

    public void setCheckInId(Long checkInId)
    {
        this.checkInId = checkInId;
    }

    public Long getCheckInId() 
    {
        return checkInId;
    }
    public void setDeviceName(String deviceName) 
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName() 
    {
        return deviceName;
    }
    public void setPhotoUrl(String photoUrl) 
    {
        this.photoUrl = photoUrl;
    }

    public String getPhotoUrl() 
    {
        return photoUrl;
    }
    public void setPatrolDescribe(String patrolDescribe) 
    {
        this.patrolDescribe = patrolDescribe;
    }

    public String getPatrolDescribe() 
    {
        return patrolDescribe;
    }
    public void setReportTime(Date reportTime) 
    {
        this.reportTime = reportTime;
    }

    public Date getReportTime() 
    {
        return reportTime;
    }
    public void setReportPerson(Long reportPerson) 
    {
        this.reportPerson = reportPerson;
    }

    public Long getReportPerson() 
    {
        return reportPerson;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("checkInId", getCheckInId())
            .append("deviceName", getDeviceName())
            .append("photoUrl", getPhotoUrl())
            .append("patrolDescribe", getPatrolDescribe())
            .append("reportTime", getReportTime())
            .append("reportPerson", getReportPerson())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
