package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.List;

/**
 * 消息对象 t_message_info
 * 
 * @author zehong
 * @date 2023-09-14
 */
public class TMessageInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 消息主键 */
    private Long messageId;

    /** 消息标题 */
    @Excel(name = "消息标题")
    private String messageTitle;

    /** 消息内容 */
    @Excel(name = "消息内容")
    private String messageContent;

    /** 消息状态（0正常 1关闭） */
    @Excel(name = "消息状态", readConverterExp = "0=正常,1=关闭")
    private String status;

    private Long personId;

    private Integer topping;


    private String messageDetailStatus;

    private Long messageDetailId;

    private String fujianUrl;

    public String getFujianUrl() {
        return fujianUrl;
    }

    public void setFujianUrl(String fujianUrl) {
        this.fujianUrl = fujianUrl;
    }

    public Integer getTopping() {
        return topping;
    }

    public void setTopping(Integer topping) {
        this.topping = topping;
    }

    public Long getMessageDetailId() {
        return messageDetailId;
    }

    public void setMessageDetailId(Long messageDetailId) {
        this.messageDetailId = messageDetailId;
    }

    public String getMessageDetailStatus() {
        return messageDetailStatus;
    }

    public void setMessageDetailStatus(String messageDetailStatus) {
        this.messageDetailStatus = messageDetailStatus;
    }

    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    private String[] personIds;
    private List<TMessageDetailInfo> messageDetailInfoList;

    public String[] getPersonIds() {
        return personIds;
    }

    public void setPersonIds(String[] personIds) {
        this.personIds = personIds;
    }

    public void setMessageId(Long messageId)
    {
        this.messageId = messageId;
    }

    public Long getMessageId() 
    {
        return messageId;
    }
    public void setMessageTitle(String messageTitle) 
    {
        this.messageTitle = messageTitle;
    }

    public String getMessageTitle() 
    {
        return messageTitle;
    }
    public void setMessageContent(String messageContent) 
    {
        this.messageContent = messageContent;
    }

    public String getMessageContent() 
    {
        return messageContent;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }

    public List<TMessageDetailInfo> getMessageDetailInfoList() {
        return messageDetailInfoList;
    }

    public void setMessageDetailInfoList(List<TMessageDetailInfo> messageDetailInfoList) {
        this.messageDetailInfoList = messageDetailInfoList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("messageId", getMessageId())
            .append("messageTitle", getMessageTitle())
            .append("messageContent", getMessageContent())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
