package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 消息详情对象 t_message_detail_info
 * 
 * @author zehong
 * @date 2023-09-14
 */
public class TMessageDetailInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 消息详情主键 */
    private Long messageDetailId;

    /** 消息主键 */
    @Excel(name = "消息主键")
    private Long messageId;

    /** 接收消息人 */
    @Excel(name = "接收消息人")
    private Long personId;

    /** 消息状态：0未读 1已读 */
    @Excel(name = "消息状态：0未读 1已读")
    private String messageDetailStatus;

    private String PersonName;

    public void setMessageDetailId(Long messageDetailId) 
    {
        this.messageDetailId = messageDetailId;
    }

    public Long getMessageDetailId() 
    {
        return messageDetailId;
    }
    public void setMessageId(Long messageId) 
    {
        this.messageId = messageId;
    }

    public Long getMessageId() 
    {
        return messageId;
    }
    public void setPersonId(Long personId) 
    {
        this.personId = personId;
    }

    public Long getPersonId() 
    {
        return personId;
    }
    public void setMessageDetailStatus(String messageDetailStatus) 
    {
        this.messageDetailStatus = messageDetailStatus;
    }

    public String getMessageDetailStatus() 
    {
        return messageDetailStatus;
    }

    public String getPersonName() {
        return PersonName;
    }

    public void setPersonName(String personName) {
        PersonName = personName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("messageDetailId", getMessageDetailId())
            .append("messageId", getMessageId())
            .append("personId", getPersonId())
            .append("messageDetailStatus", getMessageDetailStatus())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
