package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 液化气第三方对接接口记录对象 t_lpg_third_party_docking_interface_record
 * 
 * @author zehong
 * @date 2024-09-18
 */
public class TLpgThirdPartyDockingInterfaceRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long recordId;

    /** 接口名称 */
    private String interfaceName;

    /** 状态0-成功，1-失败 */
    private String state;

    /** 接收的数据 */
    private String receiveData;

    /** 返回的数据 */
    private String returnData;

    /** 失败原因 */
    private String failureReason;

    /** 记录的时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveDate;

    private String qybm;

    public void setRecordId(Long recordId) 
    {
        this.recordId = recordId;
    }

    public Long getRecordId() 
    {
        return recordId;
    }
    public void setInterfaceName(String interfaceName) 
    {
        this.interfaceName = interfaceName;
    }

    public String getInterfaceName() 
    {
        return interfaceName;
    }
    public void setState(String state) 
    {
        this.state = state;
    }

    public String getState() 
    {
        return state;
    }
    public void setReceiveData(String receiveData) 
    {
        this.receiveData = receiveData;
    }

    public String getReceiveData() 
    {
        return receiveData;
    }
    public void setReturnData(String returnData) 
    {
        this.returnData = returnData;
    }

    public String getReturnData() 
    {
        return returnData;
    }
    public void setFailureReason(String failureReason) 
    {
        this.failureReason = failureReason;
    }

    public String getFailureReason() 
    {
        return failureReason;
    }
    public void setReceiveDate(Date receiveDate) 
    {
        this.receiveDate = receiveDate;
    }

    public String getQybm() {
        return qybm;
    }

    public void setQybm(String qybm) {
        this.qybm = qybm;
    }

    public Date getReceiveDate()
    {
        return receiveDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("recordId", getRecordId())
            .append("interfaceName", getInterfaceName())
            .append("state", getState())
            .append("receiveData", getReceiveData())
            .append("returnData", getReturnData())
            .append("failureReason", getFailureReason())
            .append("receiveDate", getReceiveDate())
            .toString();
    }
}
