package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 液化石油安检记录对象 t_lpg_safe_check_record
 * 
 * @author zehong
 * @date 2024-07-22
 */
public class TLpgSafeCheckRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 安检主键 */
    private Long safeCheckId;

    /** 储配站 */
    @Excel(name = "储配站")
    private String stationName;

    /** 用户名 */
    @Excel(name = "用户名")
    private String gasUser;

    /** 0.居民 1.非居民 */
    @Excel(name = "用户类型",readConverterExp = "0=居民,1=非居民")
    private String gasUserType;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String telNum;

    /** 用户地址 */
    @Excel(name = "用户地址")
    private String gasUserAddress;

    /** 安检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "安检时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date safeCheckDate;

    /** 安检人 */
    @Excel(name = "安检人")
    private String safeCheckPerson;

    /** 气瓶数量 */
    @Excel(name = "气瓶数量")
    private Integer bottleNum;

    /** 入户状态：0.正常入户 1.拒绝安检 */
    @Excel(name = "入户状态",readConverterExp = "0=正常入户,1=拒绝安检")
    private String checkInStatus;

    /** 燃气灶具检查情况:0.合格 1.无3C认证 2.无熄火保护装置 */
    @Excel(name = "燃气灶具检查情况",readConverterExp = "0=合格,1=无3C认证,2=无熄火保护装置")
    private String stoveCheckStatus;

    /** 燃气灶具检查情况 */
    @Excel(name = "燃气灶具检查情况照片")
    private String stoveCheckPic;

    /** 连接软管检查情况:0.合格 1.普通橡胶软管 2.三通连接软管 3.长度超过两米且未使用硬质钢管链接 4.穿越墙体、门窗顶棚和地面 */
    @Excel(name = "连接软管检查情况",readConverterExp = "0=合格,1=普通橡胶软管,2=三通连接软管,3=长度超过两米且未使用硬质钢管链接,4=穿越墙体、门窗顶棚和地面")
    private String hoseCheckStatus;

    /** 连接软管检查情况 */
    @Excel(name = "连接软管检查情况照片")
    private String hoseCheckPic;

    /** 减压阀检查情况:0.合格 1.可调节 2.五自闭功能 */
    @Excel(name = "减压阀检查情况",readConverterExp = "0=合格,1=可调节,2=五自闭功能")
    private String valveCheckStatus;

    /** 减压阀检查情况 */
    @Excel(name = "减压阀检查情况照片")
    private String valveCheckPic;

    /** 液化气钢瓶检查情况:0.合格 1.部分有码且可追溯 2.有码但不可追溯 3.钢瓶无码 */
    @Excel(name = "液化气钢瓶检查情况",readConverterExp = "0=合格,1=部分有码且可追溯,2=有码但不可追溯,3=钢瓶无码")
    private String bottleCheckStatus;

    /** 液化气钢瓶检查情况 */
    @Excel(name = "液化气钢瓶检查情况照片")
    private String bottleCheckPic;

    /** 报警器加电磁切断阀检查情况:0.合格 1.有但未使用 2.有但未实现联动 3.无 4.非液化气专用报警器 5.安装位置大于0.3米 */
    @Excel(name = "报警器加电磁切断阀检查情况",readConverterExp = "0=合格,1=有但未使用,2=有但未实现联动,3=无,4=非液化气专用报警器,5=安装位置大于0.3米")
    private String alarmCheckStatus;

    /** 报警器加电磁切断阀检查情况 */
    @Excel(name = "报警器加电磁切断阀检查情况照片")
    private String alarmCheckPic;

    /** 用气场所检查情况:0.合格 1.高层建筑（裙房） 2.地下（半地下）室 3.车库或半地下车库 4.通风不良的场所 5.50公斤钢瓶超过两只或15公斤钢瓶超过七只未设置独立的气瓶间 */
    @Excel(name = "用气场所检查情况", readConverterExp = "0=合格,1=高层建筑（裙房）,2=地下（半地下）室,3=车库或半地下车库,4=通风不良的场所 5.50公斤钢瓶超过两只或15公斤钢瓶超过七只未设置独立的气瓶间")
    private String placeCheckStatus;

    /** 用气场所检查情况 */
    @Excel(name = "用气场所检查情况照片")
    private String placeCheckPic;

    /** 安检人员签名 */
    @Excel(name = "安检人员签名")
    private String checkPersonSign;

    /** 用户签字 */
    @Excel(name = "用户签字")
    private String gasUserSign;

    /** 删除状态：0.否 1.是 */
    //@Excel(name = "删除状态：0.否 1.是")
    private String isDel;

    private Long userId;


    /**
     * 用户自有编号 接收第三方数据时暂时使用
     */
    private String userOwnId;

    public void setSafeCheckId(Long safeCheckId) 
    {
        this.safeCheckId = safeCheckId;
    }

    public Long getSafeCheckId()
    {
        return safeCheckId;
    }
    public void setStationName(String stationName)
    {
        this.stationName = stationName;
    }

    public String getStationName()
    {
        return stationName;
    }
    public void setGasUser(String gasUser) 
    {
        this.gasUser = gasUser;
    }

    public String getGasUser() 
    {
        return gasUser;
    }
    public void setGasUserType(String gasUserType) 
    {
        this.gasUserType = gasUserType;
    }

    public String getGasUserType() 
    {
        return gasUserType;
    }
    public void setTelNum(String telNum) 
    {
        this.telNum = telNum;
    }

    public String getTelNum() 
    {
        return telNum;
    }

    public String getGasUserAddress() {
        return gasUserAddress;
    }

    public void setGasUserAddress(String gasUserAddress) {
        this.gasUserAddress = gasUserAddress;
    }

    public void setSafeCheckDate(Date safeCheckDate)
    {
        this.safeCheckDate = safeCheckDate;
    }

    public Date getSafeCheckDate() 
    {
        return safeCheckDate;
    }
    public void setSafeCheckPerson(String safeCheckPerson) 
    {
        this.safeCheckPerson = safeCheckPerson;
    }

    public String getSafeCheckPerson() 
    {
        return safeCheckPerson;
    }
    public void setBottleNum(Integer bottleNum) 
    {
        this.bottleNum = bottleNum;
    }

    public Integer getBottleNum() 
    {
        return bottleNum;
    }
    public void setCheckInStatus(String checkInStatus) 
    {
        this.checkInStatus = checkInStatus;
    }

    public String getCheckInStatus() 
    {
        return checkInStatus;
    }
    public void setStoveCheckStatus(String stoveCheckStatus) 
    {
        this.stoveCheckStatus = stoveCheckStatus;
    }

    public String getStoveCheckStatus() 
    {
        return stoveCheckStatus;
    }
    public void setStoveCheckPic(String stoveCheckPic) 
    {
        this.stoveCheckPic = stoveCheckPic;
    }

    public String getStoveCheckPic() 
    {
        return stoveCheckPic;
    }
    public void setHoseCheckStatus(String hoseCheckStatus) 
    {
        this.hoseCheckStatus = hoseCheckStatus;
    }

    public String getHoseCheckStatus() 
    {
        return hoseCheckStatus;
    }
    public void setHoseCheckPic(String hoseCheckPic) 
    {
        this.hoseCheckPic = hoseCheckPic;
    }

    public String getHoseCheckPic() 
    {
        return hoseCheckPic;
    }
    public void setValveCheckStatus(String valveCheckStatus) 
    {
        this.valveCheckStatus = valveCheckStatus;
    }

    public String getValveCheckStatus() 
    {
        return valveCheckStatus;
    }
    public void setValveCheckPic(String valveCheckPic) 
    {
        this.valveCheckPic = valveCheckPic;
    }

    public String getValveCheckPic() 
    {
        return valveCheckPic;
    }
    public void setBottleCheckStatus(String bottleCheckStatus) 
    {
        this.bottleCheckStatus = bottleCheckStatus;
    }

    public String getBottleCheckStatus() 
    {
        return bottleCheckStatus;
    }
    public void setBottleCheckPic(String bottleCheckPic) 
    {
        this.bottleCheckPic = bottleCheckPic;
    }

    public String getBottleCheckPic() 
    {
        return bottleCheckPic;
    }
    public void setAlarmCheckStatus(String alarmCheckStatus) 
    {
        this.alarmCheckStatus = alarmCheckStatus;
    }

    public String getAlarmCheckStatus() 
    {
        return alarmCheckStatus;
    }
    public void setAlarmCheckPic(String alarmCheckPic) 
    {
        this.alarmCheckPic = alarmCheckPic;
    }

    public String getAlarmCheckPic() 
    {
        return alarmCheckPic;
    }
    public void setPlaceCheckStatus(String placeCheckStatus) 
    {
        this.placeCheckStatus = placeCheckStatus;
    }

    public String getPlaceCheckStatus() 
    {
        return placeCheckStatus;
    }
    public void setPlaceCheckPic(String placeCheckPic) 
    {
        this.placeCheckPic = placeCheckPic;
    }

    public String getPlaceCheckPic() 
    {
        return placeCheckPic;
    }
    public void setCheckPersonSign(String checkPersonSign) 
    {
        this.checkPersonSign = checkPersonSign;
    }

    public String getCheckPersonSign() 
    {
        return checkPersonSign;
    }
    public void setGasUserSign(String gasUserSign) 
    {
        this.gasUserSign = gasUserSign;
    }

    public String getGasUserSign() 
    {
        return gasUserSign;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserOwnId() {
        return userOwnId;
    }

    public void setUserOwnId(String userOwnId) {
        this.userOwnId = userOwnId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("safeCheckId", getSafeCheckId())
            .append("stationName", getStationName())
            .append("gasUser", getGasUser())
            .append("gasUserType", getGasUserType())
            .append("telNum", getTelNum())
            .append("safeCheckDate", getSafeCheckDate())
            .append("safeCheckPerson", getSafeCheckPerson())
            .append("bottleNum", getBottleNum())
            .append("checkInStatus", getCheckInStatus())
            .append("stoveCheckStatus", getStoveCheckStatus())
            .append("stoveCheckPic", getStoveCheckPic())
            .append("hoseCheckStatus", getHoseCheckStatus())
            .append("hoseCheckPic", getHoseCheckPic())
            .append("valveCheckStatus", getValveCheckStatus())
            .append("valveCheckPic", getValveCheckPic())
            .append("bottleCheckStatus", getBottleCheckStatus())
            .append("bottleCheckPic", getBottleCheckPic())
            .append("alarmCheckStatus", getAlarmCheckStatus())
            .append("alarmCheckPic", getAlarmCheckPic())
            .append("placeCheckStatus", getPlaceCheckStatus())
            .append("placeCheckPic", getPlaceCheckPic())
            .append("checkPersonSign", getCheckPersonSign())
            .append("gasUserSign", getGasUserSign())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
