package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查-隐患分类分级标准对象 t_ins_sta_infor
 * 
 * @author zehong
 * @date 2024-05-17
 */
public class TInsStaInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsStaInforId;

    /** 隐患名称 */
    @Excel(name = "隐患名称")
    private String fHazardName;

    /** 隐患编码 */
    @Excel(name = "隐患编码")
    private String fHazardCode;

    /** 隐患描述 */
    @Excel(name = "隐患描述")
    private String fHazardDescribe;

    /** 对象分类 */
    @Excel(name = "对象分类")
    private String fObjectType;

    /** 隐患类别
      *1-漏气隐患 2-管道隐患 3-设备设施 4-用气环境 */
    @Excel(name = "隐患类别",dictType = "t_hazard_category")
    private Long fHazardCategory;

    /** 隐患环节/部位 */
    @Excel(name = "隐患环节/部位")
    private String fHazardLink;

    /** 隐患等级 */
    @Excel(name = "隐患等级")
    private String fHazardLevel;

    /** 隐患定义来源字段

            code, HAZARD_DEFINITION_SOURCE */
    @Excel(name = "隐患定义来源字段")
    private String fHazardDefinitionSourceCode;

    /** 整改责任归属 */
    @Excel(name = "整改责任归属")
    private String fOwnerResponse;

    /** 主管部门关联 sys_organization */
    @Excel(name = "主管部门关联")
    private Long fAdministrativeSysOrganizationId;

    /** 主管部门名称 */
    @Excel(name = "主管部门名称")
    private String fAdministrativeDepartmentName;

    /** 是否强制执法，Y-是，N-否 */
    @Excel(name = "是否强制执法",dictType = "t_is_enforcement")
    private String fIsEnforcement;

    /** 执法部门 id */
    @Excel(name = "执法部门id")
    private Long fEnforcementSysOrganizationId;

    /** 执法部门名称冗余 */
    @Excel(name = "执法部门名称")
    private String fEnforcementDepartmentName;

    /** 整改监督部门 */
    @Excel(name = "整改监督部门")
    private Long fSupervisionSysOrganizationId;

    /** 整改部门名称 */
    @Excel(name = "整改部门名称")
    private String fSupervisionDepartmentName;

    /** 整改要求 */
    @Excel(name = "整改要求")
    private String fRectRequire;

    /** 整改期限 */
    @Excel(name = "整改期限")
    private String fRectDeadline;

    /** 隐患排查依据 */
    @Excel(name = "隐患排查依据")
    private String fHazardCheckBasis;

    /** 检查项ID */
    @Excel(name = "检查项ID")
    private String fCheckItemId;

    /** 检查部门 */
    @Excel(name = "检查部门")
    private String fCheckDept;

    /** 检查方法 */
    @Excel(name = "检查方法")
    private String fCheckMethod;

    /** 执法参考依据 */
    @Excel(name = "执法参考依据")
    private String fEnforcementAccording;

    /** 系统默认 createBy */
    @Excel(name = "创建人")
    private String fCreateBy;

    /** 系统默认 createTime */
    @Excel(name = "创建时间")
    private String fCreateTime;

    /** 系统默认updateBy */
    @Excel(name = "更新人")
    private String fUpdateBy;

    /** 系统默认updateTime */
    @Excel(name = "更新时间")
    private String fUpdateTime;

    /** 删除标记0-可用，1-已删除 */
    @Excel(name = "删除标记",dictType = "t_delete_flag")
    private Long fDeleteFlag;

    public void setfInsStaInforId(Long fInsStaInforId) 
    {
        this.fInsStaInforId = fInsStaInforId;
    }

    public Long getfInsStaInforId() 
    {
        return fInsStaInforId;
    }
    public void setfHazardName(String fHazardName) 
    {
        this.fHazardName = fHazardName;
    }

    public String getfHazardName() 
    {
        return fHazardName;
    }
    public void setfHazardCode(String fHazardCode) 
    {
        this.fHazardCode = fHazardCode;
    }

    public String getfHazardCode() 
    {
        return fHazardCode;
    }
    public void setfHazardDescribe(String fHazardDescribe) 
    {
        this.fHazardDescribe = fHazardDescribe;
    }

    public String getfHazardDescribe() 
    {
        return fHazardDescribe;
    }
    public void setfObjectType(String fObjectType) 
    {
        this.fObjectType = fObjectType;
    }

    public String getfObjectType() 
    {
        return fObjectType;
    }
    public void setfHazardCategory(Long fHazardCategory) 
    {
        this.fHazardCategory = fHazardCategory;
    }

    public Long getfHazardCategory() 
    {
        return fHazardCategory;
    }
    public void setfHazardLink(String fHazardLink) 
    {
        this.fHazardLink = fHazardLink;
    }

    public String getfHazardLink() 
    {
        return fHazardLink;
    }
    public void setfHazardLevel(String fHazardLevel) 
    {
        this.fHazardLevel = fHazardLevel;
    }

    public String getfHazardLevel() 
    {
        return fHazardLevel;
    }
    public void setfHazardDefinitionSourceCode(String fHazardDefinitionSourceCode) 
    {
        this.fHazardDefinitionSourceCode = fHazardDefinitionSourceCode;
    }

    public String getfHazardDefinitionSourceCode() 
    {
        return fHazardDefinitionSourceCode;
    }
    public void setfOwnerResponse(String fOwnerResponse) 
    {
        this.fOwnerResponse = fOwnerResponse;
    }

    public String getfOwnerResponse() 
    {
        return fOwnerResponse;
    }
    public void setfAdministrativeSysOrganizationId(Long fAdministrativeSysOrganizationId) 
    {
        this.fAdministrativeSysOrganizationId = fAdministrativeSysOrganizationId;
    }

    public Long getfAdministrativeSysOrganizationId() 
    {
        return fAdministrativeSysOrganizationId;
    }
    public void setfAdministrativeDepartmentName(String fAdministrativeDepartmentName) 
    {
        this.fAdministrativeDepartmentName = fAdministrativeDepartmentName;
    }

    public String getfAdministrativeDepartmentName() 
    {
        return fAdministrativeDepartmentName;
    }
    public void setfIsEnforcement(String fIsEnforcement) 
    {
        this.fIsEnforcement = fIsEnforcement;
    }

    public String getfIsEnforcement() 
    {
        return fIsEnforcement;
    }
    public void setfEnforcementSysOrganizationId(Long fEnforcementSysOrganizationId) 
    {
        this.fEnforcementSysOrganizationId = fEnforcementSysOrganizationId;
    }

    public Long getfEnforcementSysOrganizationId() 
    {
        return fEnforcementSysOrganizationId;
    }
    public void setfEnforcementDepartmentName(String fEnforcementDepartmentName) 
    {
        this.fEnforcementDepartmentName = fEnforcementDepartmentName;
    }

    public String getfEnforcementDepartmentName() 
    {
        return fEnforcementDepartmentName;
    }
    public void setfSupervisionSysOrganizationId(Long fSupervisionSysOrganizationId) 
    {
        this.fSupervisionSysOrganizationId = fSupervisionSysOrganizationId;
    }

    public Long getfSupervisionSysOrganizationId() 
    {
        return fSupervisionSysOrganizationId;
    }
    public void setfSupervisionDepartmentName(String fSupervisionDepartmentName) 
    {
        this.fSupervisionDepartmentName = fSupervisionDepartmentName;
    }

    public String getfSupervisionDepartmentName() 
    {
        return fSupervisionDepartmentName;
    }
    public void setfRectRequire(String fRectRequire) 
    {
        this.fRectRequire = fRectRequire;
    }

    public String getfRectRequire() 
    {
        return fRectRequire;
    }
    public void setfRectDeadline(String fRectDeadline) 
    {
        this.fRectDeadline = fRectDeadline;
    }

    public String getfRectDeadline() 
    {
        return fRectDeadline;
    }
    public void setfHazardCheckBasis(String fHazardCheckBasis) 
    {
        this.fHazardCheckBasis = fHazardCheckBasis;
    }

    public String getfHazardCheckBasis() 
    {
        return fHazardCheckBasis;
    }
    public void setfCheckItemId(String fCheckItemId) 
    {
        this.fCheckItemId = fCheckItemId;
    }

    public String getfCheckItemId() 
    {
        return fCheckItemId;
    }
    public void setfCheckDept(String fCheckDept) 
    {
        this.fCheckDept = fCheckDept;
    }

    public String getfCheckDept() 
    {
        return fCheckDept;
    }
    public void setfCheckMethod(String fCheckMethod) 
    {
        this.fCheckMethod = fCheckMethod;
    }

    public String getfCheckMethod() 
    {
        return fCheckMethod;
    }
    public void setfEnforcementAccording(String fEnforcementAccording) 
    {
        this.fEnforcementAccording = fEnforcementAccording;
    }

    public String getfEnforcementAccording() 
    {
        return fEnforcementAccording;
    }
    public void setfCreateBy(String fCreateBy) 
    {
        this.fCreateBy = fCreateBy;
    }

    public String getfCreateBy() 
    {
        return fCreateBy;
    }
    public void setfCreateTime(String fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public String getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfUpdateBy(String fUpdateBy) 
    {
        this.fUpdateBy = fUpdateBy;
    }

    public String getfUpdateBy() 
    {
        return fUpdateBy;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfDeleteFlag(Long fDeleteFlag) 
    {
        this.fDeleteFlag = fDeleteFlag;
    }

    public Long getfDeleteFlag() 
    {
        return fDeleteFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsStaInforId", getfInsStaInforId())
            .append("fHazardName", getfHazardName())
            .append("fHazardCode", getfHazardCode())
            .append("fHazardDescribe", getfHazardDescribe())
            .append("fObjectType", getfObjectType())
            .append("fHazardCategory", getfHazardCategory())
            .append("fHazardLink", getfHazardLink())
            .append("fHazardLevel", getfHazardLevel())
            .append("fHazardDefinitionSourceCode", getfHazardDefinitionSourceCode())
            .append("fOwnerResponse", getfOwnerResponse())
            .append("fAdministrativeSysOrganizationId", getfAdministrativeSysOrganizationId())
            .append("fAdministrativeDepartmentName", getfAdministrativeDepartmentName())
            .append("fIsEnforcement", getfIsEnforcement())
            .append("fEnforcementSysOrganizationId", getfEnforcementSysOrganizationId())
            .append("fEnforcementDepartmentName", getfEnforcementDepartmentName())
            .append("fSupervisionSysOrganizationId", getfSupervisionSysOrganizationId())
            .append("fSupervisionDepartmentName", getfSupervisionDepartmentName())
            .append("fRectRequire", getfRectRequire())
            .append("fRectDeadline", getfRectDeadline())
            .append("fHazardCheckBasis", getfHazardCheckBasis())
            .append("fCheckItemId", getfCheckItemId())
            .append("fCheckDept", getfCheckDept())
            .append("fCheckMethod", getfCheckMethod())
            .append("fEnforcementAccording", getfEnforcementAccording())
            .append("fCreateBy", getfCreateBy())
            .append("fCreateTime", getfCreateTime())
            .append("fUpdateBy", getfUpdateBy())
            .append("fUpdateTime", getfUpdateTime())
            .append("fDeleteFlag", getfDeleteFlag())
            .toString();
    }
}
