package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查-检查范围对象 t_ins_scope_infor
 * 
 * @author zehong
 * @date 2024-05-16
 */
public class TInsScopeInfor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fScopeInforId;

    /** 关联检查任务表 */
    private Long fHazardCheckTaskId;

    @Excel(name = "任务名称")
    private String fName;

    /** 对象分类, RGASU-农村管道燃气用户, LPGRR-农村液化石油气

            用户, URBAN-城镇管道燃气用户, LPGUR-城镇液化石油气用

            户, UNITG-单位燃气用户, GASPL-燃气厂站, GASPT-燃气管道, GASCO-燃气企业, ICS-第三方施工, GRD-燃气主管部门 */
    @Excel(name = "对象分类",dictType = "t_object_type")
    private String fObjectType;

    /** 检查表实例关联Id */
    @Excel(name = "检查表实例关联Id")
    private Long fHazardCheckTableRecordId;

    /** 抽查要求 1：抽查;0-全覆盖 */
    @Excel(name = "抽查要求",dictType = "t_spot_check_type")
    private String fSpotCheckType;

    /** {"district":2,"town":1,"countByDistrict":2,"village":1,"house":1,"to

            wnBottleGas":0.3,"townBottleGasCon":2} */
    @Excel(name = "范围数据")
    private String fSpotCheck;

    /** T-主城区(默认)，F-三市 */
    @Excel(name = "城区标识",dictType = "t_special_flag")
    private String fSpecialFlag;

    /** 此对象应检数据 */
    @Excel(name = "此对象应检数据")
    private Long fLotCount;

    /** 抽查细类：全覆盖为空，其他情况是不分，多个细节用，拼接 */
    @Excel(name = "抽查细类")
    private String fSubobjecttypeCheckTypeDesc;

    /** 删除标记，0-可用，1-已删除 */
    @Excel(name = "删除标记",dictType = "t_delete_flag")
    private Long fDeleteFlag;

    /** 描述 */
    @Excel(name = "描述")
    private String fRemark;

    /** 创建时间 */
    @Excel(name = "创建时间")
    private String fCreateTime;

    /** 创建人，当前操作人登录名称 */
    @Excel(name = "创建人")
    private String fCreateBy;

    /** 修改时间 */
    @Excel(name = "修改时间")
    private String fUpdateTime;

    /** 修改人，当前操作人登录名称 */
    @Excel(name = "修改人")
    private String fModifyBy;

    public void setfScopeInforId(Long fScopeInforId) 
    {
        this.fScopeInforId = fScopeInforId;
    }

    public Long getfScopeInforId() 
    {
        return fScopeInforId;
    }
    public void setfHazardCheckTaskId(Long fHazardCheckTaskId) 
    {
        this.fHazardCheckTaskId = fHazardCheckTaskId;
    }

    public Long getfHazardCheckTaskId() 
    {
        return fHazardCheckTaskId;
    }

    public String getfName() {
        return fName;
    }

    public void setfName(String fName) {
        this.fName = fName;
    }

    public void setfObjectType(String fObjectType)
    {
        this.fObjectType = fObjectType;
    }

    public String getfObjectType() 
    {
        return fObjectType;
    }
    public void setfHazardCheckTableRecordId(Long fHazardCheckTableRecordId) 
    {
        this.fHazardCheckTableRecordId = fHazardCheckTableRecordId;
    }

    public Long getfHazardCheckTableRecordId() 
    {
        return fHazardCheckTableRecordId;
    }
    public void setfSpotCheckType(String fSpotCheckType) 
    {
        this.fSpotCheckType = fSpotCheckType;
    }

    public String getfSpotCheckType() 
    {
        return fSpotCheckType;
    }
    public void setfSpotCheck(String fSpotCheck) 
    {
        this.fSpotCheck = fSpotCheck;
    }

    public String getfSpotCheck() 
    {
        return fSpotCheck;
    }
    public void setfSpecialFlag(String fSpecialFlag) 
    {
        this.fSpecialFlag = fSpecialFlag;
    }

    public String getfSpecialFlag() 
    {
        return fSpecialFlag;
    }
    public void setfLotCount(Long fLotCount) 
    {
        this.fLotCount = fLotCount;
    }

    public Long getfLotCount() 
    {
        return fLotCount;
    }
    public void setfSubobjecttypeCheckTypeDesc(String fSubobjecttypeCheckTypeDesc) 
    {
        this.fSubobjecttypeCheckTypeDesc = fSubobjecttypeCheckTypeDesc;
    }

    public String getfSubobjecttypeCheckTypeDesc() 
    {
        return fSubobjecttypeCheckTypeDesc;
    }
    public void setfDeleteFlag(Long fDeleteFlag) 
    {
        this.fDeleteFlag = fDeleteFlag;
    }

    public Long getfDeleteFlag() 
    {
        return fDeleteFlag;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfCreateTime(String fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public String getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfCreateBy(String fCreateBy) 
    {
        this.fCreateBy = fCreateBy;
    }

    public String getfCreateBy() 
    {
        return fCreateBy;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfModifyBy(String fModifyBy) 
    {
        this.fModifyBy = fModifyBy;
    }

    public String getfModifyBy() 
    {
        return fModifyBy;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fScopeInforId", getfScopeInforId())
            .append("fHazardCheckTaskId", getfHazardCheckTaskId())
            .append("fObjectType", getfObjectType())
            .append("fHazardCheckTableRecordId", getfHazardCheckTableRecordId())
            .append("fSpotCheckType", getfSpotCheckType())
            .append("fSpotCheck", getfSpotCheck())
            .append("fSpecialFlag", getfSpecialFlag())
            .append("fLotCount", getfLotCount())
            .append("fSubobjecttypeCheckTypeDesc", getfSubobjecttypeCheckTypeDesc())
            .append("fDeleteFlag", getfDeleteFlag())
            .append("fRemark", getfRemark())
            .append("fCreateTime", getfCreateTime())
            .append("fCreateBy", getfCreateBy())
            .append("fUpdateTime", getfUpdateTime())
            .append("fModifyBy", getfModifyBy())
            .toString();
    }
}
