package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气隐患对象 t_hidden_trouble_info
 *
 * @author zehong
 * @date 2022-03-24
 */
public class THiddenTroubleInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 隐患id */
    private Long hiddenTroubleId;

    /** 权属单位 */
    private String beyondEnterpriseId;

    /** 巡检任务id */
    private Long workId;

    /** 隐患名称 */
    @Excel(name = "隐患名称")
    private String hiddenTroubleName;

    /** 隐患等级: 1.I级 2.II级 3.III级 */
    @Excel(name = "隐患等级")
    private String hiddenTroubleLevel;

    /** 隐患类型: 1.漏气 2.腐蚀 3.裂缝 4.设备故障 5.安全距离不足 6.管道承重 7.其他 */
    @Excel(name = "隐患类型")
    private String hiddenTroubleType;

    private Integer hiddenSource;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 图片地址 */
    private String pictureUrl;

    /** 隐患描述 */
    @Excel(name = "隐患描述")
    private String hiddenTroubleDescribe;

    /** 上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "上报时间")
    private String reportTime;

    /** 上报人 */
    @Excel(name = "上报人")
    private String reportPerson;

    /** 隐患处理状态: 1.待处理 2.处理中 3.已完成 */
    @Excel(name = "隐患处理状态")
    private String hiddenTroubleDealStatus;

    /** 隐患处理情况 */
    @Excel(name = "隐患处理情况")
    private String hiddenTroubleDealCondition;

    /** 隐患处理完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "隐患处理完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date hiddenTroubleDealFinishTime;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 处理图片*/
    private String dealUrl;

    /**上报人名称*/
    private String reportPersonName;

    private String source;

    private String township;

    private Integer fuheGroupNum;
    private String rejectContent;

    private String videoUrl;
    private String dealVideo;

    private String  dealPerson;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date  fuheTime;
    private String  fuhePerson;

    @Excel(name = "是否上报",readConverterExp = "0=否,1=是")
    private Integer isReport;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reportBeginTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reportEndTime;


    public Integer getHiddenSource() {
        return hiddenSource;
    }

    public void setHiddenSource(Integer hiddenSource) {
        this.hiddenSource = hiddenSource;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getDealVideo() {
        return dealVideo;
    }

    public void setDealVideo(String dealVideo) {
        this.dealVideo = dealVideo;
    }

    public String getDealPerson() {
        return dealPerson;
    }

    public void setDealPerson(String dealPerson) {
        this.dealPerson = dealPerson;
    }

    public Date getFuheTime() {
        return fuheTime;
    }

    public void setFuheTime(Date fuheTime) {
        this.fuheTime = fuheTime;
    }

    public String getFuhePerson() {
        return fuhePerson;
    }

    public void setFuhePerson(String fuhePerson) {
        this.fuhePerson = fuhePerson;
    }

    public Integer getFuheGroupNum() {
        return fuheGroupNum;
    }

    public void setFuheGroupNum(Integer fuheGroupNum) {
        this.fuheGroupNum = fuheGroupNum;
    }

    public String getRejectContent() {
        return rejectContent;
    }

    public void setRejectContent(String rejectContent) {
        this.rejectContent = rejectContent;
    }

    public String getDealUrl() {
        return dealUrl;
    }

    public void setDealUrl(String dealUrl) {
        this.dealUrl = dealUrl;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTownship() {
        return township;
    }

    public void setTownship(String township) {
        this.township = township;
    }

    public Integer timeType;

    public Integer getTimeType() {
        return timeType;
    }

    public void setTimeType(Integer timeType) {
        this.timeType = timeType;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getReportPersonName() {
        return reportPersonName;
    }

    public void setReportPersonName(String reportPersonName) {
        this.reportPersonName = reportPersonName;
    }

    public void setHiddenTroubleId(Long hiddenTroubleId)
    {
        this.hiddenTroubleId = hiddenTroubleId;
    }

    public Long getHiddenTroubleId()
    {
        return hiddenTroubleId;
    }
    public void setWorkId(Long workId)
    {
        this.workId = workId;
    }

    public Long getWorkId()
    {
        return workId;
    }
    public void setHiddenTroubleName(String hiddenTroubleName)
    {
        this.hiddenTroubleName = hiddenTroubleName;
    }

    public String getHiddenTroubleName()
    {
        return hiddenTroubleName;
    }
    public void setHiddenTroubleLevel(String hiddenTroubleLevel)
    {
        this.hiddenTroubleLevel = hiddenTroubleLevel;
    }

    public String getHiddenTroubleLevel()
    {
        return hiddenTroubleLevel;
    }
    public void setHiddenTroubleType(String hiddenTroubleType)
    {
        this.hiddenTroubleType = hiddenTroubleType;
    }

    public String getHiddenTroubleType()
    {
        return hiddenTroubleType;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setPictureUrl(String pictureUrl)
    {
        this.pictureUrl = pictureUrl;
    }

    public String getPictureUrl()
    {
        return pictureUrl;
    }
    public void setHiddenTroubleDescribe(String hiddenTroubleDescribe)
    {
        this.hiddenTroubleDescribe = hiddenTroubleDescribe;
    }

    public String getHiddenTroubleDescribe()
    {
        return hiddenTroubleDescribe;
    }

    public String getReportTime() {
        return reportTime;
    }

    public void setReportTime(String reportTime) {
        this.reportTime = reportTime;
    }


    public void setReportPerson(String reportPerson)
    {
        this.reportPerson = reportPerson;
    }

    public String getReportPerson()
    {
        return reportPerson;
    }
    public void setHiddenTroubleDealStatus(String hiddenTroubleDealStatus)
    {
        this.hiddenTroubleDealStatus = hiddenTroubleDealStatus;
    }

    public String getHiddenTroubleDealStatus()
    {
        return hiddenTroubleDealStatus;
    }
    public void setHiddenTroubleDealCondition(String hiddenTroubleDealCondition)
    {
        this.hiddenTroubleDealCondition = hiddenTroubleDealCondition;
    }

    public String getHiddenTroubleDealCondition()
    {
        return hiddenTroubleDealCondition;
    }


    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }


    public Date getHiddenTroubleDealFinishTime() {
        return hiddenTroubleDealFinishTime;
    }

    public void setHiddenTroubleDealFinishTime(Date hiddenTroubleDealFinishTime) {
        this.hiddenTroubleDealFinishTime = hiddenTroubleDealFinishTime;
    }

    public Integer getIsReport() {
        return isReport;
    }

    public void setIsReport(Integer isReport) {
        this.isReport = isReport;
    }

    public Date getReportBeginTime() {
        return reportBeginTime;
    }

    public void setReportBeginTime(Date reportBeginTime) {
        this.reportBeginTime = reportBeginTime;
    }

    public Date getReportEndTime() {
        return reportEndTime;
    }

    public void setReportEndTime(Date reportEndTime) {
        this.reportEndTime = reportEndTime;
    }

    @Override
    public String toString() {
        return "THiddenTroubleInfo{" +
                "hiddenTroubleId=" + hiddenTroubleId +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", workId=" + workId +
                ", hiddenTroubleName='" + hiddenTroubleName + '\'' +
                ", hiddenTroubleLevel='" + hiddenTroubleLevel + '\'' +
                ", hiddenTroubleType='" + hiddenTroubleType + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", pictureUrl='" + pictureUrl + '\'' +
                ", hiddenTroubleDescribe='" + hiddenTroubleDescribe + '\'' +
                ", reportTime='" + reportTime + '\'' +
                ", reportPerson='" + reportPerson + '\'' +
                ", hiddenTroubleDealStatus='" + hiddenTroubleDealStatus + '\'' +
                ", hiddenTroubleDealCondition='" + hiddenTroubleDealCondition + '\'' +
                ", hiddenTroubleDealFinishTime='" + hiddenTroubleDealFinishTime + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                ", dealUrl='" + dealUrl + '\'' +
                ", reportPersonName='" + reportPersonName + '\'' +
                ", source='" + source + '\'' +
                ", township='" + township + '\'' +
                ", timeType=" + timeType +
                '}';
    }
}
