package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 储配站信息对象 t_gas_storage_station_info
 * 
 * @author zehong
 * @date 2023-08-14
 */
public class TGasStorageStationInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 储配站主键 */
    private Long stationId;

    /** 名称 */
    @Excel(name = "储配站名称")
    private String stationName;

    /** 代码 */
    @Excel(name = "储配站编号")
    private String stationCode;

    /** 负责人 */
    @Excel(name = "负责人")
    private String director;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String telNum;

    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 许可证文件 */
    @Excel(name = "许可证文件")
    private String licenceFile;

    /** 许可证编号 */
    @Excel(name = "许可证编号")
    private String licenceCode;

    /** 许可证有效时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "许可证日期起", width = 30, dateFormat = "yyyy-MM-dd")
    private Date licenceEffectiveDate;

    /** 许可证有效期截止日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "许可证日期止", width = 30, dateFormat = "yyyy-MM-dd")
    private Date licenceLimitDate;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    private Date createBeginTime;

    private Date createEndTime;

    public void setStationId(Long stationId) 
    {
        this.stationId = stationId;
    }

    public Long getStationId() 
    {
        return stationId;
    }
    public void setStationName(String stationName) 
    {
        this.stationName = stationName;
    }

    public String getStationName() 
    {
        return stationName;
    }
    public void setStationCode(String stationCode) 
    {
        this.stationCode = stationCode;
    }

    public String getStationCode() 
    {
        return stationCode;
    }
    public void setDirector(String director) 
    {
        this.director = director;
    }

    public String getDirector() 
    {
        return director;
    }
    public void setTelNum(String telNum) 
    {
        this.telNum = telNum;
    }

    public String getTelNum() 
    {
        return telNum;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLicenceFile(String licenceFile) 
    {
        this.licenceFile = licenceFile;
    }

    public String getLicenceFile() 
    {
        return licenceFile;
    }
    public void setLicenceCode(String licenceCode) 
    {
        this.licenceCode = licenceCode;
    }

    public String getLicenceCode() 
    {
        return licenceCode;
    }
    public void setLicenceEffectiveDate(Date licenceEffectiveDate) 
    {
        this.licenceEffectiveDate = licenceEffectiveDate;
    }

    public Date getLicenceEffectiveDate() 
    {
        return licenceEffectiveDate;
    }
    public void setLicenceLimitDate(Date licenceLimitDate) 
    {
        this.licenceLimitDate = licenceLimitDate;
    }

    public Date getLicenceLimitDate() 
    {
        return licenceLimitDate;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }

    public Date getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(Date createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public Date getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(Date createEndTime) {
        this.createEndTime = createEndTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("stationId", getStationId())
            .append("stationName", getStationName())
            .append("stationCode", getStationCode())
            .append("director", getDirector())
            .append("telNum", getTelNum())
            .append("address", getAddress())
            .append("licenceFile", getLicenceFile())
            .append("licenceCode", getLicenceCode())
            .append("licenceEffectiveDate", getLicenceEffectiveDate())
            .append("licenceLimitDate", getLicenceLimitDate())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
