package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 事件处置对象 t_event_handle
 * 
 * @author zehong
 * @date 2022-03-19
 */
public class TEventHandle extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long handleId;

    /** 事件id */
    @Excel(name = "事件id")
    private Long eventId;

    @Excel(name = "类型")
    private Integer eventType;

    /** 企业id */
    @Excel(name = "企业id")
    private Long enterpriseId;

    /** 企业名称 */
    @Excel(name = "企业名称")
    private String enterpriseName;

    /** 处置信息 */
    @Excel(name = "处置信息")
    private String management;

    private String managementEvent;

    /** 应急预案id */
    @Excel(name = "应急预案id")
    private Long planId;

    @Excel(name = "应急预案标题")
    private String planTitle;

    @Excel(name = "应急预案附件地址")
    private String planUrl;
    /** 指导意见 */
    @Excel(name = "指导意见")
    private String guidanceOpinion;

    /** 指导时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "指导时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date guidanceTime;


    private Integer readStatus;
    /** 0未删除 1已删除 */
    private Integer isDel;

    public Integer getEventType() {
        return eventType;
    }

    public void setEventType(Integer eventType) {
        this.eventType = eventType;
    }

    public Integer getReadStatus() {
        return readStatus;
    }

    public void setReadStatus(Integer readStatus) {
        this.readStatus = readStatus;
    }

    public String getPlanTitle() {
        return planTitle;
    }

    public void setPlanTitle(String planTitle) {
        this.planTitle = planTitle;
    }

    public String getPlanUrl() {
        return planUrl;
    }

    public void setPlanUrl(String planUrl) {
        this.planUrl = planUrl;
    }

    public String getManagementEvent() {
        return managementEvent;
    }

    public void setManagementEvent(String managementEvent) {
        this.managementEvent = managementEvent;
    }

    public void setHandleId(Long handleId)
    {
        this.handleId = handleId;
    }

    public Long getHandleId() 
    {
        return handleId;
    }
    public void setEventId(Long eventId) 
    {
        this.eventId = eventId;
    }

    public Long getEventId() 
    {
        return eventId;
    }
    public void setEnterpriseId(Long enterpriseId) 
    {
        this.enterpriseId = enterpriseId;
    }

    public Long getEnterpriseId() 
    {
        return enterpriseId;
    }
    public void setEnterpriseName(String enterpriseName) 
    {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseName() 
    {
        return enterpriseName;
    }
    public void setManagement(String management) 
    {
        this.management = management;
    }

    public String getManagement() 
    {
        return management;
    }
    public void setPlanId(Long planId) 
    {
        this.planId = planId;
    }

    public Long getPlanId() 
    {
        return planId;
    }
    public void setGuidanceOpinion(String guidanceOpinion) 
    {
        this.guidanceOpinion = guidanceOpinion;
    }

    public String getGuidanceOpinion() 
    {
        return guidanceOpinion;
    }
    public void setGuidanceTime(Date guidanceTime) 
    {
        this.guidanceTime = guidanceTime;
    }

    public Date getGuidanceTime() 
    {
        return guidanceTime;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("handleId", getHandleId())
            .append("eventId", getEventId())
            .append("enterpriseId", getEnterpriseId())
            .append("enterpriseName", getEnterpriseName())
            .append("management", getManagement())
            .append("planId", getPlanId())
            .append("guidanceOpinion", getGuidanceOpinion())
            .append("guidanceTime", getGuidanceTime())
            .append("isDel", getIsDel())
            .append("createTime", getCreateTime())
            .toString();
    }
}
