package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 从业人员信息对象 t_employed_people_info
 *
 * @author zehong
 * @date 2022-01-25
 */
public class TEmployedPeopleInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 从业人员id */
    private Long employedPeopleId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String employedPeopleName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 证书编号 */
    @Excel(name = "技能岗位证书编号")
    private String certificateNum;

    /** 受聘企业名称 */
    @Excel(name = "受聘企业名称")
    private String beyondEnterpriseName;

    /** 受聘企业id */
    private String beyondEnterpriseId;

    /** 发证部门 */
    @Excel(name = "发证部门")
    private String registerExaminationType;

    /** 任职岗位：1.主要负责人 2.安全管理人员3.运行维护和抢修人员 */
    @Excel(name = "任职岗位")
    private String peopleOccupation;

    /** 发证日期 */
    @Excel(name = "发证日期")
    @JsonFormat(pattern="yyyy-MM-dd")
    private String issueDate;

    /** 复检日期 */
    @Excel(name = "复检日期")
    private String certificateChange;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 头像地址 */
    private String avatarAddress;

    public String getAvatarAddress() {
        return avatarAddress;
    }

    public void setAvatarAddress(String avatarAddress) {
        this.avatarAddress = avatarAddress;
    }

    public void setEmployedPeopleId(Long employedPeopleId)
    {
        this.employedPeopleId = employedPeopleId;
    }

    public Long getEmployedPeopleId()
    {
        return employedPeopleId;
    }
    public void setEmployedPeopleName(String employedPeopleName)
    {
        this.employedPeopleName = employedPeopleName;
    }

    public String getEmployedPeopleName()
    {
        return employedPeopleName;
    }
    public void setIdCard(String idCard)
    {
        this.idCard = idCard;
    }

    public String getIdCard()
    {
        return idCard;
    }
    public void setCertificateNum(String certificateNum)
    {
        this.certificateNum = certificateNum;
    }

    public String getCertificateNum()
    {
        return certificateNum;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName)
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName()
    {
        return beyondEnterpriseName;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setRegisterExaminationType(String registerExaminationType)
    {
        this.registerExaminationType = registerExaminationType;
    }

    public String getRegisterExaminationType()
    {
        return registerExaminationType;
    }
    public void setPeopleOccupation(String peopleOccupation)
    {
        this.peopleOccupation = peopleOccupation;
    }

    public String getPeopleOccupation()
    {
        return peopleOccupation;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public void setCertificateChange(String certificateChange) {
        this.certificateChange = certificateChange;
    }

    public String getCertificateChange()
    {
        return certificateChange;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TEmployedPeopleInfo{" +
                "employedPeopleId=" + employedPeopleId +
                ", employedPeopleName='" + employedPeopleName + '\'' +
                ", idCard='" + idCard + '\'' +
                ", certificateNum='" + certificateNum + '\'' +
                ", beyondEnterpriseName='" + beyondEnterpriseName + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", registerExaminationType='" + registerExaminationType + '\'' +
                ", peopleOccupation='" + peopleOccupation + '\'' +
                ", issueDate='" + issueDate + '\'' +
                ", certificateChange='" + certificateChange + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                ", avatarAddress='" + avatarAddress + '\'' +
                '}';
    }
}
