package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备监控对象 t_device_report_data
 * 
 * @author zehong
 * @date 2022-02-17
 */
public class TDeviceReportData extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备上报id */
    private Long deviceReportDataId;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备id（物联网编号） */
    @Excel(name = "设备id", readConverterExp = "物=联网编号")
    private String deviceNum;

    /** 标况累计量 */
    @Excel(name = "标况累计量")
    private BigDecimal standardConditionAccumulation;

    /** 工况累计量 */
    @Excel(name = "工况累计量")
    private BigDecimal workingConditionAccumulation;

    /** 逆向标况累计量 */
    @Excel(name = "逆向标况累计量")
    private BigDecimal backingStandardConditionAccumulation;

    /** 剩余量 */
    @Excel(name = "剩余量")
    private BigDecimal residualQuantity;

    /** 标况流量 */
    @Excel(name = "标况流量")
    private BigDecimal standardConditionFlow;

    /** 工况流量 */
    @Excel(name = "工况流量")
    private BigDecimal workingConditionFlow;

    /** 温度 */
    @Excel(name = "温度")
    private BigDecimal temperature;

    /** 压力 */
    @Excel(name = "压力")
    private BigDecimal pressure;

    /** 上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上报时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date reportTime;

    /** 通讯状态 */
    @Excel(name = "通讯状态")
    private String communicationStatus;

    /** 设备状态 */
    @Excel(name = "设备状态")
    private String deviceStatus;

    /** 所属企业id */
    //@Excel(name = "所属企业id")
    private String beyondEnterpriseId;

    /** 所属企业名称 */
    @Excel(name = "所属企业名称")
    private String beyondEnterpriseName;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private String beyondDeviceName;

    /**
     * 1 压力表
     * 2 流量计
     */
    private String deviceType;

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getBeyondDeviceName() {
        return beyondDeviceName;
    }

    public void setBeyondDeviceName(String beyondDeviceName) {
        this.beyondDeviceName = beyondDeviceName;
    }

    public void setDeviceReportDataId(Long deviceReportDataId)
    {
        this.deviceReportDataId = deviceReportDataId;
    }

    public Long getDeviceReportDataId() 
    {
        return deviceReportDataId;
    }
    public void setDeviceName(String deviceName) 
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName() 
    {
        return deviceName;
    }
    public void setDeviceNum(String deviceNum) 
    {
        this.deviceNum = deviceNum;
    }

    public String getDeviceNum() 
    {
        return deviceNum;
    }
    public void setStandardConditionAccumulation(BigDecimal standardConditionAccumulation) 
    {
        this.standardConditionAccumulation = standardConditionAccumulation;
    }

    public BigDecimal getStandardConditionAccumulation() 
    {
        return standardConditionAccumulation;
    }
    public void setWorkingConditionAccumulation(BigDecimal workingConditionAccumulation) 
    {
        this.workingConditionAccumulation = workingConditionAccumulation;
    }

    public BigDecimal getWorkingConditionAccumulation() 
    {
        return workingConditionAccumulation;
    }
    public void setBackingStandardConditionAccumulation(BigDecimal backingStandardConditionAccumulation) 
    {
        this.backingStandardConditionAccumulation = backingStandardConditionAccumulation;
    }

    public BigDecimal getBackingStandardConditionAccumulation() 
    {
        return backingStandardConditionAccumulation;
    }
    public void setResidualQuantity(BigDecimal residualQuantity) 
    {
        this.residualQuantity = residualQuantity;
    }

    public BigDecimal getResidualQuantity() 
    {
        return residualQuantity;
    }
    public void setStandardConditionFlow(BigDecimal standardConditionFlow) 
    {
        this.standardConditionFlow = standardConditionFlow;
    }

    public BigDecimal getStandardConditionFlow() 
    {
        return standardConditionFlow;
    }
    public void setWorkingConditionFlow(BigDecimal workingConditionFlow) 
    {
        this.workingConditionFlow = workingConditionFlow;
    }

    public BigDecimal getWorkingConditionFlow() 
    {
        return workingConditionFlow;
    }
    public void setTemperature(BigDecimal temperature) 
    {
        this.temperature = temperature;
    }

    public BigDecimal getTemperature() 
    {
        return temperature;
    }
    public void setPressure(BigDecimal pressure) 
    {
        this.pressure = pressure;
    }

    public BigDecimal getPressure() 
    {
        return pressure;
    }
    public void setReportTime(Date reportTime) 
    {
        this.reportTime = reportTime;
    }

    public Date getReportTime() 
    {
        return reportTime;
    }
    public void setCommunicationStatus(String communicationStatus) 
    {
        this.communicationStatus = communicationStatus;
    }

    public String getCommunicationStatus() 
    {
        return communicationStatus;
    }
    public void setDeviceStatus(String deviceStatus) 
    {
        this.deviceStatus = deviceStatus;
    }

    public String getDeviceStatus() 
    {
        return deviceStatus;
    }
    public void setBeyondEnterpriseId(String  beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String  getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("deviceReportDataId", getDeviceReportDataId())
            .append("deviceName", getDeviceName())
            .append("deviceNum", getDeviceNum())
            .append("standardConditionAccumulation", getStandardConditionAccumulation())
            .append("workingConditionAccumulation", getWorkingConditionAccumulation())
            .append("backingStandardConditionAccumulation", getBackingStandardConditionAccumulation())
            .append("residualQuantity", getResidualQuantity())
            .append("standardConditionFlow", getStandardConditionFlow())
            .append("workingConditionFlow", getWorkingConditionFlow())
            .append("temperature", getTemperature())
            .append("pressure", getPressure())
            .append("reportTime", getReportTime())
            .append("communicationStatus", getCommunicationStatus())
            .append("deviceStatus", getDeviceStatus())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
