package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.system.domain.vo.UserManageSafetyDeviceExportVo;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气用户对象 t_detector_user
 *
 * @author zehong
 * @date 2022-02-07
 */
public class TDetectorUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 用户id */
    private Long userId;

    /**
     * 用户自有id - 新版本导入时使用，别的地方不用
     */
    private String userOwnId;

    /** 用户账号 */
    private String username;

    /** 用户名称 */
    @Excel(name = "用户名称")
    private String nickName;

    /** 权属单位 */
    private String beyondEnterpriseId;

    /** 用户类型（1居民用户，2商业用户，3工业用户） */
    @Excel(name = "用户类型")
    private String userType;

    @Excel(name = "燃气类型",dictType = "gas_type")
    private String gasType;
    /** 地址 */
    @Excel(name = "地址")
    private String address;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 邮箱 */
    @Excel(name = "邮箱")
    private String email;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private String errorMsg;

    /**
     * 所属企业名称
     */
    private String beyondEnterpriseName;

    /**
     * 是否入户安检 0否 1是
     */
    private String isInspect;

    /**
     * 安检人
     */
    private String inspector;

    /**
     * 安检时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectDate;

    /**
     * 安检信息
     */
    private List<TWorkTaskInspect> inspectInfo;

    /**
     * 任务主键
     */
    private Long taskId;

    /**
     * 居住区村庄id
     */
    private Long villageId;

    /**
     * 居住区村庄名称
     */
    @Excel(name = "居住区(村、庄)")
    private String villageName;

    private List<Long> hasInspectUser;

    /**
     * 安全装置集合 导出时使用
     */
    private List<UserManageSafetyDeviceExportVo> userManageSafetyDeviceExportVos;

    public String getBeyondEnterpriseName() {
        return beyondEnterpriseName;
    }

    public void setBeyondEnterpriseName(String beyondEnterpriseName) {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public Long getUserId()
    {
        return userId;
    }
    public void setUsername(String username)
    {
        this.username = username;
    }

    public String getUsername()
    {
        return username;
    }
    public void setNickName(String nickName)
    {
        this.nickName = nickName;
    }

    public String getNickName()
    {
        return nickName;
    }
    public void setUserType(String userType)
    {
        this.userType = userType;
    }

    public String getUserType()
    {
        return userType;
    }
    public void setAddress(String address)
    {
        this.address = address;
    }

    public String getAddress()
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setLinkman(String linkman)
    {
        this.linkman = linkman;
    }

    public String getLinkman()
    {
        return linkman;
    }
    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhone()
    {
        return phone;
    }
    public void setEmail(String email)
    {
        this.email = email;
    }

    public String getEmail()
    {
        return email;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    public String getIsInspect() {
        return isInspect;
    }

    public void setIsInspect(String isInspect) {
        this.isInspect = isInspect;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public Date getInspectDate() {
        return inspectDate;
    }

    public void setInspectDate(Date inspectDate) {
        this.inspectDate = inspectDate;
    }

    public List<TWorkTaskInspect> getInspectInfo() {
        return inspectInfo;
    }

    public void setInspectInfo(List<TWorkTaskInspect> inspectInfo) {
        this.inspectInfo = inspectInfo;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public List<Long> getHasInspectUser() {
        return hasInspectUser;
    }

    public void setHasInspectUser(List<Long> hasInspectUser) {
        this.hasInspectUser = hasInspectUser;
    }

    public String getGasType() {
        return gasType;
    }

    public void setGasType(String gasType) {
        this.gasType = gasType;
    }

    public Long getVillageId() {
        return villageId;
    }

    public void setVillageId(Long villageId) {
        this.villageId = villageId;
    }

    public String getVillageName() {
        return villageName;
    }

    public void setVillageName(String villageName) {
        this.villageName = villageName;
    }

    public String getUserOwnId() {
        return userOwnId;
    }

    public void setUserOwnId(String userOwnId) {
        this.userOwnId = userOwnId;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<UserManageSafetyDeviceExportVo> getUserManageSafetyDeviceExportVos() {
        return userManageSafetyDeviceExportVos;
    }

    public void setUserManageSafetyDeviceExportVos(List<UserManageSafetyDeviceExportVo> userManageSafetyDeviceExportVos) {
        this.userManageSafetyDeviceExportVos = userManageSafetyDeviceExportVos;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        TDetectorUser detectorUser = (TDetectorUser) obj;
        return Objects.equals(userOwnId,detectorUser.getUserOwnId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(userOwnId);
    }

    @Override
    public String toString() {
        return "TDetectorUser{" +
                "userId=" + userId +
                ", username='" + username + '\'' +
                ", nickName='" + nickName + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", userType='" + userType + '\'' +
                ", address='" + address + '\'' +
                ", longitude=" + longitude +
                ", latitude=" + latitude +
                ", linkman='" + linkman + '\'' +
                ", phone='" + phone + '\'' +
                ", email='" + email + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
