package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 充装记录对象 t_air_charge_record
 *
 * @author zehong
 * @date 2023-08-21
 */
public class TAirChargeRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 充装主键 */
    private Long chargeRecordId;

    /** 储配站主键 */
    private Long stationId;

    @Excel(name = "储配站")
    private String stationName;

    @Excel(name = "气瓶条码")
    private String bottleCode;

    private String bottleCapacity;

    private String bottleStatus;

    @Excel(name = "充装人员")
    private String chargeOperatorName;

    /** 气瓶主键 */
    private Long bottleId;

    /** 充装人员 */
    private Long chargeOperator;

    /** 充装量 */
    @Excel(name = "充装量")
    private String chargeMeasure;

    /** 充装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "充装时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date chargeDate;

    private String chargeDates;

    /** 删除状态：0.否 1.是 */
    private String isDel;

    private Date chargeBeginTime;

    private Date chargeEndTime;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getChargeDates() {
        return chargeDates;
    }

    public void setChargeDates(String chargeDates) {
        this.chargeDates = chargeDates;
    }

    public void setChargeRecordId(Long chargeRecordId)
    {
        this.chargeRecordId = chargeRecordId;
    }

    public Long getChargeRecordId()
    {
        return chargeRecordId;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setBottleId(Long bottleId)
    {
        this.bottleId = bottleId;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getBottleCode() {
        return bottleCode;
    }

    public void setBottleCode(String bottleCode) {
        this.bottleCode = bottleCode;
    }

    public String getBottleCapacity() {
        return bottleCapacity;
    }

    public void setBottleCapacity(String bottleCapacity) {
        this.bottleCapacity = bottleCapacity;
    }

    public String getBottleStatus() {
        return bottleStatus;
    }

    public void setBottleStatus(String bottleStatus) {
        this.bottleStatus = bottleStatus;
    }

    public String getChargeOperatorName() {
        return chargeOperatorName;
    }

    public void setChargeOperatorName(String chargeOperatorName) {
        this.chargeOperatorName = chargeOperatorName;
    }

    public Long getBottleId()
    {
        return bottleId;
    }
    public void setChargeOperator(Long chargeOperator)
    {
        this.chargeOperator = chargeOperator;
    }

    public Long getChargeOperator()
    {
        return chargeOperator;
    }
    public void setChargeMeasure(String chargeMeasure)
    {
        this.chargeMeasure = chargeMeasure;
    }

    public String getChargeMeasure()
    {
        return chargeMeasure;
    }
    public void setChargeDate(Date chargeDate)
    {
        this.chargeDate = chargeDate;
    }

    public Date getChargeDate()
    {
        return chargeDate;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    public Date getChargeBeginTime() {
        return chargeBeginTime;
    }

    public void setChargeBeginTime(Date chargeBeginTime) {
        this.chargeBeginTime = chargeBeginTime;
    }

    public Date getChargeEndTime() {
        return chargeEndTime;
    }

    public void setChargeEndTime(Date chargeEndTime) {
        this.chargeEndTime = chargeEndTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("chargeRecordId", getChargeRecordId())
            .append("stationId", getStationId())
            .append("bottleId", getBottleId())
            .append("chargeOperator", getChargeOperator())
            .append("chargeMeasure", getChargeMeasure())
            .append("chargeDate", getChargeDate())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
