package com.zehong.web.controller.task;

import java.util.List;
import java.util.stream.Collectors;
import java.util.Map;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkTask;
import com.zehong.system.service.ITWorkTaskService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检巡查任务Controller
 * 
 * @author zehong
 * @date 2023-09-14
 */
@RestController
@RequestMapping("/system/task")
public class TWorkTaskController extends BaseController
{
    @Autowired
    private ITWorkTaskService tWorkTaskService;

    /**
     * 查询巡检巡查任务列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkTask tWorkTask)
    {
        startPage();
        if(!SecurityUtils.isAdmin(SecurityUtils.getLoginUser().getUser().getUserId()) && !isGovernment()){
            tWorkTask.setCreateEnterpriseId(SecurityUtils.getLoginUser().getUser().getDeptId());
        }
        if(isGovernment()){
            tWorkTask.setIsReport(1);
        }
        List<TWorkTask> list = tWorkTaskService.selectTWorkTaskList(tWorkTask);
        return getDataTable(list);
    }
    /**
     * 导出巡检巡查任务列表
     */
    @Log(title = "巡检巡查任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkTask tWorkTask)
    {
        List<TWorkTask> list = tWorkTaskService.selectTWorkTaskList(tWorkTask);
        ExcelUtil<TWorkTask> util = new ExcelUtil<TWorkTask>(TWorkTask.class);
        return util.exportExcel(list, "巡检巡查任务数据");
    }

    /**
     * 获取巡检巡查任务详细信息
     */
    @GetMapping(value = "/{taskId}")
    public AjaxResult getInfo(@PathVariable("taskId") Long taskId)
    {
        return AjaxResult.success(tWorkTaskService.selectTWorkTaskById(taskId));
    }

    /**
     * 新增巡检巡查任务
     */
    @Log(title = "巡检巡查任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkTask tWorkTask)
    {
        if(isGovernment()){
            tWorkTask.setIsReport(1);
        }
        return toAjax(tWorkTaskService.insertTWorkTask(tWorkTask));
    }

    /**
     * 修改巡检巡查任务
     */
    @Log(title = "巡检巡查任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkTask tWorkTask)
    {
        return toAjax(tWorkTaskService.updateTWorkTask(tWorkTask));
    }

    /**
     * 删除巡检巡查任务
     */
    @Log(title = "巡检巡查任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{taskIds}")
    public AjaxResult remove(@PathVariable Long[] taskIds)
    {
        return toAjax(tWorkTaskService.deleteTWorkTaskByIds(taskIds));
    }

    /**
     * 小程序list
     * @param tWorkTask
     * @return
     */
    @GetMapping("/wxlist")
    public TableDataInfo wxlist(TWorkTask tWorkTask)
    {
        startPage();
        List<TWorkTask> list = tWorkTaskService.selectTaskListxiao(tWorkTask);
        return getDataTable(list);
    }

    /**
     * 判断是否为政府角色
     * @return
     */
    private boolean isGovernment(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("gov");
    }

    /**
     * 查询任务人员
     * @param taskId
     * @return
     */
    @GetMapping("/wxpersonname")
    public AjaxResult wxlist(Long taskId)
    {
        Map<String,Object> personName = tWorkTaskService.selectPersonName(taskId);
        return AjaxResult.success(personName);
    }

    /**
     * 中途添加执行任务人员
     * @return
     */
    @PostMapping("/addmember")
    public AjaxResult addmember(@RequestBody TWorkTask tWorkTask)
    {
        return AjaxResult.success(tWorkTaskService.addmember(tWorkTask));
    }


}
