package com.zehong.web.controller.task;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TUserLocation;
import com.zehong.system.service.ITUserLocationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2023-09-18
 */
@RestController
@RequestMapping("/task/location")
public class TUserLocationController extends BaseController
{
    @Autowired
    private ITUserLocationService tUserLocationService;

    /**
     * 查询【请填写功能名称】列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TUserLocation tUserLocation)
    {
        startPage();
        List<TUserLocation> list = tUserLocationService.selectTUserLocationList(tUserLocation);
        return getDataTable(list);
    }

    @GetMapping("/locationList")
    public AjaxResult locationList(TUserLocation tUserLocation) {
        List<TUserLocation> list = tUserLocationService.selectTUserLocationList(tUserLocation);
        return AjaxResult.success(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUserLocation tUserLocation)
    {
        List<TUserLocation> list = tUserLocationService.selectTUserLocationList(tUserLocation);
        ExcelUtil<TUserLocation> util = new ExcelUtil<TUserLocation>(TUserLocation.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUserLocationService.selectTUserLocationById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUserLocation tUserLocation)
    {
        return toAjax(tUserLocationService.insertTUserLocation(tUserLocation));
    }

    /**
     * 修改【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUserLocation tUserLocation)
    {
        return toAjax(tUserLocationService.updateTUserLocation(tUserLocation));
    }

    /**
     * 删除【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUserLocationService.deleteTUserLocationByIds(ids));
    }

    @GetMapping("/selectTUserLocationListByGroup")
    public AjaxResult selectTUserLocationListByGroup(TUserLocation tUserLocation) {

        return AjaxResult.success(tUserLocationService.selectTUserLocationListByGroup(tUserLocation));
    }
}
