package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TYehuaqiDevice;
import com.zehong.system.service.ITYehuaqiDeviceService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2022-09-14
 */
@RestController
@RequestMapping("/ system/yehuaqiDevice")
public class TYehuaqiDeviceController extends BaseController

{
    @Autowired
    private ITYehuaqiDeviceService tYehuaqiDeviceService;

    /**
     * 查询【请填写功能名称】列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TYehuaqiDevice tYehuaqiDevice)
    {
        startPage();
        List<TYehuaqiDevice> list = tYehuaqiDeviceService.selectTYehuaqiDeviceList(tYehuaqiDevice);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TYehuaqiDevice tYehuaqiDevice)
    {
        List<TYehuaqiDevice> list = tYehuaqiDeviceService.selectTYehuaqiDeviceList(tYehuaqiDevice);
        ExcelUtil<TYehuaqiDevice> util = new ExcelUtil<TYehuaqiDevice>(TYehuaqiDevice.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @GetMapping(value = "/{detectorId}")
    public AjaxResult getInfo(@PathVariable("detectorId") Long detectorId)
    {
        return AjaxResult.success(tYehuaqiDeviceService.selectTYehuaqiDeviceById(detectorId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TYehuaqiDevice tYehuaqiDevice)
    {
        return toAjax(tYehuaqiDeviceService.insertTYehuaqiDevice(tYehuaqiDevice));
    }

    /**
     * 修改【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TYehuaqiDevice tYehuaqiDevice)
    {
        return toAjax(tYehuaqiDeviceService.updateTYehuaqiDevice(tYehuaqiDevice));
    }

    /**
     * 删除【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{detectorIds}")
    public AjaxResult remove(@PathVariable Long[] detectorIds)
    {
        return toAjax(tYehuaqiDeviceService.deleteTYehuaqiDeviceByIds(detectorIds));
    }
}
