package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsTaskInfor;
import com.zehong.system.service.ITInsTaskInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-检查任务Controller
 * 
 * @author zehong
 * @date 2024-05-16
 */
@RestController
@RequestMapping("/supervision/task")
public class TInsTaskInforController extends BaseController
{
    @Autowired
    private ITInsTaskInforService tInsTaskInforService;

    /**
     * 查询监督检查-检查任务列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsTaskInfor tInsTaskInfor)
    {
        startPage();
        List<TInsTaskInfor> list = tInsTaskInforService.selectTInsTaskInforList(tInsTaskInfor);
        return getDataTable(list);
    }

    /**
     * 查询监督检查-检查任务列表
     */
    @GetMapping("/taskList")
    public AjaxResult taskList(TInsTaskInfor tInsTaskInfor){
        List<TInsTaskInfor> list = tInsTaskInforService.selectTInsTaskInforList(tInsTaskInfor);
        return AjaxResult.success(list);
    }

    /**
     * 导出监督检查-检查任务列表
     */
    @Log(title = "监督检查-检查任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsTaskInfor tInsTaskInfor)
    {
        List<TInsTaskInfor> list = tInsTaskInforService.selectTInsTaskInforList(tInsTaskInfor);
        ExcelUtil<TInsTaskInfor> util = new ExcelUtil<TInsTaskInfor>(TInsTaskInfor.class);
        return util.exportExcel(list, "监督检查-检查任务数据");
    }

    /**
     * 获取监督检查-检查任务详细信息
     */
    @GetMapping(value = "/{fInsTaskInforId}")
    public AjaxResult getInfo(@PathVariable("fInsTaskInforId") Long fInsTaskInforId)
    {
        return AjaxResult.success(tInsTaskInforService.selectTInsTaskInforById(fInsTaskInforId));
    }

    /**
     * 新增监督检查-检查任务
     */
    @Log(title = "监督检查-检查任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsTaskInfor tInsTaskInfor)
    {
        return toAjax(tInsTaskInforService.insertTInsTaskInfor(tInsTaskInfor));
    }

    /**
     * 修改监督检查-检查任务
     */
    @Log(title = "监督检查-检查任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsTaskInfor tInsTaskInfor)
    {
        return toAjax(tInsTaskInforService.updateTInsTaskInfor(tInsTaskInfor));
    }

    /**
     * 删除监督检查-检查任务
     */
    @Log(title = "监督检查-检查任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsTaskInforIds}")
    public AjaxResult remove(@PathVariable Long[] fInsTaskInforIds)
    {
        return toAjax(tInsTaskInforService.deleteTInsTaskInforByIds(fInsTaskInforIds));
    }
}
