package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsSurListInfor;
import com.zehong.system.service.ITInsSurListInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-调查项Controller
 * 
 * @author zehong
 * @date 2024-05-18
 */
@RestController
@RequestMapping("/supervision/survey")
public class TInsSurListInforController extends BaseController
{
    @Autowired
    private ITInsSurListInforService tInsSurListInforService;

    /**
     * 查询监督检查-调查项列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsSurListInfor tInsSurListInfor)
    {
        startPage();
        List<TInsSurListInfor> list = tInsSurListInforService.selectTInsSurListInforList(tInsSurListInfor);
        return getDataTable(list);
    }

    /**
     * 导出监督检查-调查项列表
     */
    @Log(title = "监督检查-调查项", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsSurListInfor tInsSurListInfor)
    {
        List<TInsSurListInfor> list = tInsSurListInforService.selectTInsSurListInforList(tInsSurListInfor);
        ExcelUtil<TInsSurListInfor> util = new ExcelUtil<TInsSurListInfor>(TInsSurListInfor.class);
        return util.exportExcel(list, "监督检查-调查项数据");
    }

    /**
     * 获取监督检查-调查项详细信息
     */
    @GetMapping(value = "/{fInsSurListInforId}")
    public AjaxResult getInfo(@PathVariable("fInsSurListInforId") Long fInsSurListInforId)
    {
        return AjaxResult.success(tInsSurListInforService.selectTInsSurListInforById(fInsSurListInforId));
    }

    /**
     * 新增监督检查-调查项
     */
    @Log(title = "监督检查-调查项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsSurListInfor tInsSurListInfor)
    {
        return toAjax(tInsSurListInforService.insertTInsSurListInfor(tInsSurListInfor));
    }

    /**
     * 修改监督检查-调查项
     */
    @Log(title = "监督检查-调查项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsSurListInfor tInsSurListInfor)
    {
        return toAjax(tInsSurListInforService.updateTInsSurListInfor(tInsSurListInfor));
    }

    /**
     * 删除监督检查-调查项
     */
    @Log(title = "监督检查-调查项", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsSurListInforIds}")
    public AjaxResult remove(@PathVariable Long[] fInsSurListInforIds)
    {
        return toAjax(tInsSurListInforService.deleteTInsSurListInforByIds(fInsSurListInforIds));
    }
}
