package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsScopeInfor;
import com.zehong.system.service.ITInsScopeInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-检查范围Controller
 * 
 * @author zehong
 * @date 2024-05-16
 */
@RestController
@RequestMapping("/supervision/scope")
public class TInsScopeInforController extends BaseController
{
    @Autowired
    private ITInsScopeInforService tInsScopeInforService;

    /**
     * 查询监督检查-检查范围列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsScopeInfor tInsScopeInfor)
    {
        startPage();
        List<TInsScopeInfor> list = tInsScopeInforService.selectTInsScopeInforList(tInsScopeInfor);
        return getDataTable(list);
    }

    /**
     * 导出监督检查-检查范围列表
     */
    @Log(title = "监督检查-检查范围", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsScopeInfor tInsScopeInfor)
    {
        List<TInsScopeInfor> list = tInsScopeInforService.selectTInsScopeInforList(tInsScopeInfor);
        ExcelUtil<TInsScopeInfor> util = new ExcelUtil<TInsScopeInfor>(TInsScopeInfor.class);
        return util.exportExcel(list, "监督检查-检查范围数据");
    }

    /**
     * 获取监督检查-检查范围详细信息
     */
    @GetMapping(value = "/{fScopeInforId}")
    public AjaxResult getInfo(@PathVariable("fScopeInforId") Long fScopeInforId)
    {
        return AjaxResult.success(tInsScopeInforService.selectTInsScopeInforById(fScopeInforId));
    }

    /**
     * 新增监督检查-检查范围
     */
    @Log(title = "监督检查-检查范围", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsScopeInfor tInsScopeInfor)
    {
        return toAjax(tInsScopeInforService.insertTInsScopeInfor(tInsScopeInfor));
    }

    /**
     * 修改监督检查-检查范围
     */
    @Log(title = "监督检查-检查范围", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsScopeInfor tInsScopeInfor)
    {
        return toAjax(tInsScopeInforService.updateTInsScopeInfor(tInsScopeInfor));
    }

    /**
     * 删除监督检查-检查范围
     */
    @Log(title = "监督检查-检查范围", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fScopeInforIds}")
    public AjaxResult remove(@PathVariable Long[] fScopeInforIds)
    {
        return toAjax(tInsScopeInforService.deleteTInsScopeInforByIds(fScopeInforIds));
    }
}
