package com.zehong.web.controller.supervise;
import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.service.ITEmployedPeopleInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeInfo;
import com.zehong.system.service.ITPipeInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 管道信息Controller
 *
 * @author zehong
 * @date 2022-01-26
 */
@RestController
@RequestMapping("/supervise/pipe")
public class TPipeInfoController extends BaseController
{
    @Autowired
    private ITPipeInfoService tPipeInfoService;

    @Autowired
    private ITEmployedPeopleInfoService tEmployedPeopleInfoService;

    /**
     * 查询管道信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPipeInfo tPipeInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tPipeInfo.setBeyondEnterpriseId(user.getDeptId());
        startPage();
        List<TPipeInfo> list = tPipeInfoService.selectTPipeInfoList(tPipeInfo);
        return getDataTable(list);
    }

    /**
     * 导出管道信息列表
     */
    @Log(title = "管道信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeInfo tPipeInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tPipeInfo.setBeyondEnterpriseId(user.getDeptId());
        List<TPipeInfo> list = tPipeInfoService.selectTPipeInfoList(tPipeInfo);
        ExcelUtil<TPipeInfo> util = new ExcelUtil<TPipeInfo>(TPipeInfo.class);
        return util.exportExcel(list, "管道信息数据");
    }

    /**
     * 获取管道信息详细信息
     */
    @GetMapping(value = "/{pipeId}")
    public AjaxResult getInfo(@PathVariable("pipeId") Long pipeId)
    {
        return AjaxResult.success(tPipeInfoService.selectTPipeInfoById(pipeId));
    }

    /**
     * 新增管道信息
     */
    @Log(title = "管道信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeInfo tPipeInfo) {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tPipeInfo.getBeyondEnterpriseId());
        tPipeInfo.setBeyondEnterpriseName(EnterpriseName);

        return toAjax(tPipeInfoService.insertTPipeInfo(tPipeInfo));
    }

    /**
     * 修改管道信息
     */
    @Log(title = "管道信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeInfo tPipeInfo) {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tPipeInfo.getBeyondEnterpriseId());
        tPipeInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tPipeInfoService.updateTPipeInfo(tPipeInfo));
    }

    /**
     * 删除管道信息
     */
    @Log(title = "管道信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{pipeIds}")
    public AjaxResult remove(@PathVariable Long[] pipeIds)
    {
        return toAjax(tPipeInfoService.deleteTPipeInfoByIds(pipeIds));
    }
}
