package com.zehong.web.controller.supervise;

import com.zehong.common.annotation.Log;
import com.zehong.common.config.GassafetyProgressConfig;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.utils.uuid.UUID;
import com.zehong.framework.config.ServerConfig;
import com.zehong.system.domain.TEnterpriseInfo;
import com.zehong.system.domain.vo.TEnterpriseInfoVO;
import com.zehong.system.service.ITEnterpriseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;

/**
 * 企业信息Controller
 *
 * @author zehong
 * @date 2022-01-24
 */
@RestController
@RequestMapping("/regulation/info")
public class TEnterpriseInfoController extends BaseController
{
    @Autowired
    private ITEnterpriseInfoService tEnterpriseInfoService;
    @Autowired
    private ServerConfig serverConfig;
    /**
     * 查询企业信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEnterpriseInfo tEnterpriseInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tEnterpriseInfo.setEnterpriseId(user.getDeptId());
        startPage();
        List<TEnterpriseInfo> list = tEnterpriseInfoService.selectTEnterpriseInfoList(tEnterpriseInfo);
        return getDataTable(list);
    }

    /**
     * 查询企业类型
     * @return
     */
//    @RequestMapping("/getEnterpriseType")
//    public TableDataInfo getEnterpriseType(){
//        List<TEnterpriseInfo> enterpriseType = tEnterpriseInfoService.getEnterpriseType();
//        return getDataTable(enterpriseType);
//    }

    /**
     *查询所有企业信息
     * @param tEnterpriseInfo
     * @return
     */
    @GetMapping("/enterpriseLists")
    public TableDataInfo enterpriseLists(TEnterpriseInfo tEnterpriseInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tEnterpriseInfo.setEnterpriseId(user.getDeptId());
        List<TEnterpriseInfo> list = tEnterpriseInfoService.selectTEnterpriseInfoList(tEnterpriseInfo);
        return getDataTable(list);
    }

    /**
     *无条件查询所有企业
     * @return
     */
    @GetMapping("/queryAllEnterprise")
    public List<TEnterpriseInfo> queryAllEnterprise()
    {
        //获取用户信息
        return tEnterpriseInfoService.queryAllEnterprise();
    }


    /**
     *查询所有企业信息
     * @param tEnterpriseInfo
     * @return
     */
    @GetMapping("/enterpriseInfoList")
    public AjaxResult enterpriseInfoList(TEnterpriseInfo tEnterpriseInfo)
    {
        List<TEnterpriseInfoVO> list  = tEnterpriseInfoService.enterpriseInfoList(tEnterpriseInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出企业信息列表
     */
    @Log(title = "企业信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEnterpriseInfo tEnterpriseInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tEnterpriseInfo.setEnterpriseId(user.getDeptId());
        List<TEnterpriseInfo> list = tEnterpriseInfoService.selectTEnterpriseInfoList(tEnterpriseInfo);
        ExcelUtil<TEnterpriseInfo> util = new ExcelUtil<TEnterpriseInfo>(TEnterpriseInfo.class);
        return util.exportExcel(list, "企业信息数据");
    }

    /**
     * 获取企业信息详细信息
     */
    @GetMapping(value = "/{enterpriseId}")
    public AjaxResult getInfo(@PathVariable("enterpriseId") String enterpriseId)
    {
        return AjaxResult.success(tEnterpriseInfoService.selectTEnterpriseInfoById(enterpriseId));
    }

    /**
     * 新增企业信息
     */
    @Log(title = "企业信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEnterpriseInfo tEnterpriseInfo)
    {
        //获取用户信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        tEnterpriseInfo.setCreateEnterpriseId(user.getDeptId());
        tEnterpriseInfo.setEnterpriseId(UUID.randomUUID().toString());
        return toAjax(tEnterpriseInfoService.insertTEnterpriseInfo(tEnterpriseInfo));
    }

    /**
     * 修改企业信息
     */
    @Log(title = "企业信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEnterpriseInfo tEnterpriseInfo)
    {
        //查询修改之前图片地址
        TEnterpriseInfo tEnterpriseInfo1 = tEnterpriseInfoService.selectTEnterpriseInfoById(tEnterpriseInfo.getEnterpriseId());
        //文件删除
        if (tEnterpriseInfo1.getDoDusiness()!=null){
            // 上传文件路径
            String filePath = GassafetyProgressConfig.getUploadPath();
            String[] strs = tEnterpriseInfo1.getDoDusiness().split("upload");
            //删除图片
            File file = new File(filePath+strs[1].toString());
            // 上传文件路径
             if(file.isFile()){
               file.delete();
            }
        }
        return toAjax(tEnterpriseInfoService.updateTEnterpriseInfo(tEnterpriseInfo));
    }

    /**
     * 删除企业信息
     */
    @Log(title = "企业信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{enterpriseIds}")
    public AjaxResult remove(@PathVariable String[] enterpriseIds)
    {
        return toAjax(tEnterpriseInfoService.deleteTEnterpriseInfoByIds(enterpriseIds));
    }

    @Log(title = "项目编号", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<TEnterpriseInfo> util = new ExcelUtil<>(TEnterpriseInfo.class);
        List<TEnterpriseInfo> XmbhList = util.importExcel(file.getInputStream());
        String operName = SecurityUtils.getLoginUser().getUsername();
        String message = tEnterpriseInfoService.importEnterpriseInfo(XmbhList, updateSupport, operName);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate()
    {
        ExcelUtil<TEnterpriseInfo> util = new ExcelUtil<>(TEnterpriseInfo.class);
        return util.importTemplateExcel("燃气企业数据");
    }
}
