package com.zehong.web.controller.specialist;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TProAppInfor;
import com.zehong.system.service.ITProAppInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 行业专家库-专家申报Controller
 * 
 * @author zehong
 * @date 2024-05-06
 */
@RestController
@RequestMapping("/specialist/info")
public class TProAppInforController extends BaseController
{
    @Autowired
    private ITProAppInforService tProAppInforService;

    /**
     * 查询行业专家库-专家申报列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TProAppInfor tProAppInfor)
    {
        startPage();
        List<TProAppInfor> list = tProAppInforService.selectTProAppInforList(tProAppInfor);
        return getDataTable(list);
    }

    /**
     * 导出行业专家库-专家申报列表
     */
    @Log(title = "行业专家库-专家申报", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TProAppInfor tProAppInfor)
    {
        List<TProAppInfor> list = tProAppInforService.selectTProAppInforList(tProAppInfor);
        ExcelUtil<TProAppInfor> util = new ExcelUtil<TProAppInfor>(TProAppInfor.class);
        return util.exportExcel(list, "行业专家库-专家申报数据");
    }

    /**
     * 获取行业专家库-专家申报详细信息
     */
    @GetMapping(value = "/{fProAppInforId}")
    public AjaxResult getInfo(@PathVariable("fProAppInforId") Long fProAppInforId)
    {
        return AjaxResult.success(tProAppInforService.selectTProAppInforById(fProAppInforId));
    }

    /**
     * 新增行业专家库-专家申报
     */
    @Log(title = "行业专家库-专家申报", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TProAppInfor tProAppInfor)
    {
        return toAjax(tProAppInforService.insertTProAppInfor(tProAppInfor));
    }

    /**
     * 修改行业专家库-专家申报
     */
    @Log(title = "行业专家库-专家申报", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TProAppInfor tProAppInfor)
    {
        return toAjax(tProAppInforService.updateTProAppInfor(tProAppInfor));
    }

    /**
     * 删除行业专家库-专家申报
     */
    @Log(title = "行业专家库-专家申报", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fProAppInforIds}")
    public AjaxResult remove(@PathVariable Long[] fProAppInforIds)
    {
        return toAjax(tProAppInforService.deleteTProAppInforByIds(fProAppInforIds));
    }

    /**
     * 行业专家申报
     * @param fProAppInforId 行业专家主键
     * @return
     */
    @GetMapping("/reportProAppInfo")
    public AjaxResult reportProAppInfo(Long fProAppInforId){
        try{
            return toAjax(tProAppInforService.reportProAppInfo(fProAppInforId));
        }catch (Exception e){
            logger.error("行业专家申报接口异常=====",e);
            return AjaxResult.error("行业专家申报接口异常");
        }
    }
}
