package com.zehong.web.controller.oldpipesystem;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeOldPlanProcess;
import com.zehong.system.service.ITPipeOldPlanProcessService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 老旧管网-改造计划和进度Controller
 * 
 * @author zehong
 * @date 2024-06-15
 */
@RestController
@RequestMapping("/oldPipeSystem/plan")
public class TPipeOldPlanProcessController extends BaseController
{
    @Autowired
    private ITPipeOldPlanProcessService tPipeOldPlanProcessService;

    @Autowired
    private TokenService tokenService;

    /**
     * 查询老旧管网-改造计划和进度列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            tPipeOldPlanProcess.setfUploadType("1");
        }
        startPage();
        List<TPipeOldPlanProcess> list = tPipeOldPlanProcessService.selectTPipeOldPlanProcessList(tPipeOldPlanProcess);
        return getDataTable(list);
    }

    /**
     * 导出老旧管网-改造计划和进度列表
     */
    @Log(title = "老旧管网-改造计划和进度", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        List<TPipeOldPlanProcess> list = tPipeOldPlanProcessService.exportTPipeOldPlanProcessList(tPipeOldPlanProcess);
        ExcelUtil<TPipeOldPlanProcess> util = new ExcelUtil<TPipeOldPlanProcess>(TPipeOldPlanProcess.class);
        AjaxResult ajaxResult = util.exportExcel(list, "老旧管网-改造计划和进度数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取老旧管网-改造计划和进度详细信息
     */
    @GetMapping(value = "/{fOldPlanProcessId}")
    public AjaxResult getInfo(@PathVariable("fOldPlanProcessId") Long fOldPlanProcessId)
    {
        return AjaxResult.success(tPipeOldPlanProcessService.selectTPipeOldPlanProcessById(fOldPlanProcessId));
    }

    /**
     * 新增老旧管网-改造计划和进度
     */
    @Log(title = "老旧管网-改造计划和进度", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        return toAjax(tPipeOldPlanProcessService.insertTPipeOldPlanProcess(tPipeOldPlanProcess));
    }

    /**
     * 修改老旧管网-改造计划和进度
     */
    @Log(title = "老旧管网-改造计划和进度", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeOldPlanProcess tPipeOldPlanProcess)
    {
        return toAjax(tPipeOldPlanProcessService.updateTPipeOldPlanProcess(tPipeOldPlanProcess));
    }

    /**
     * 删除老旧管网-改造计划和进度
     */
    @Log(title = "老旧管网-改造计划和进度", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fOldPlanProcessIds}")
    public AjaxResult remove(@PathVariable Long[] fOldPlanProcessIds)
    {
        return toAjax(tPipeOldPlanProcessService.deleteTPipeOldPlanProcessByIds(fOldPlanProcessIds));
    }

    /**
     * 政府端 上传计划和进度
     * @param fOldPlanProcessId 计划id
     * @return
     */
    @GetMapping("/reportPipeOldPlanProcess")
    public AjaxResult reportPipeOldPlanProcess(Long fOldPlanProcessId){
        try{
            return toAjax(tPipeOldPlanProcessService.reportPipeOldPlanProcess(fOldPlanProcessId));
        }catch (Exception e){
            logger.error("上传计划和进度接口异常=====",e);
            return AjaxResult.error("上传计划和进度接口异常");
        }
    }

    /**
     * 企业端 上传计划和进度
     * @param fOldPlanProcessId 计划id
     * @return
     */
    @GetMapping("/entReportPipeOldPlanProcess")
    public AjaxResult entReportPipeOldPlanProcess(Long fOldPlanProcessId) {
        return toAjax(tPipeOldPlanProcessService.entReportPipeOldPlanProcess(fOldPlanProcessId));
    }
}
