package com.zehong.web.controller.message;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMessageDetailInfo;
import com.zehong.system.service.ITMessageDetailInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 消息详情Controller
 * 
 * @author zehong
 * @date 2023-09-14
 */
@RestController
@RequestMapping("/message/detail")
public class TMessageDetailInfoController extends BaseController
{
    @Autowired
    private ITMessageDetailInfoService tMessageDetailInfoService;

    /**
     * 查询消息详情列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TMessageDetailInfo tMessageDetailInfo)
    {
        startPage();
        List<TMessageDetailInfo> list = tMessageDetailInfoService.selectTMessageDetailInfoList(tMessageDetailInfo);
        return getDataTable(list);
    }

    /**
     * 导出消息详情列表
     */
    @Log(title = "消息详情", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMessageDetailInfo tMessageDetailInfo)
    {
        List<TMessageDetailInfo> list = tMessageDetailInfoService.selectTMessageDetailInfoList(tMessageDetailInfo);
        ExcelUtil<TMessageDetailInfo> util = new ExcelUtil<TMessageDetailInfo>(TMessageDetailInfo.class);
        return util.exportExcel(list, "消息详情数据");
    }

    /**
     * 获取消息详情详细信息
     */
    @GetMapping(value = "/{messageDetailId}")
    public AjaxResult getInfo(@PathVariable("messageDetailId") Long messageDetailId)
    {
        return AjaxResult.success(tMessageDetailInfoService.selectTMessageDetailInfoById(messageDetailId));
    }

    /**
     * 新增消息详情
     */
    @Log(title = "消息详情", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMessageDetailInfo tMessageDetailInfo)
    {
        return toAjax(tMessageDetailInfoService.insertTMessageDetailInfo(tMessageDetailInfo));
    }

    /**
     * 修改消息详情
     */
    @Log(title = "消息详情", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMessageDetailInfo tMessageDetailInfo)
    {
        return toAjax(tMessageDetailInfoService.updateTMessageDetailInfo(tMessageDetailInfo));
    }

    /**
     * 删除消息详情
     */
    @Log(title = "消息详情", businessType = BusinessType.DELETE)
	@DeleteMapping("/{messageDetailIds}")
    public AjaxResult remove(@PathVariable Long[] messageDetailIds)
    {
        return toAjax(tMessageDetailInfoService.deleteTMessageDetailInfoByIds(messageDetailIds));
    }
}
