package com.zehong.web.controller.lpgRegulation;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TLpgGasBottleFiles;
import com.zehong.system.service.ITLpgGasBottleFilesService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油气-气瓶档案Controller
 * 
 * @author zehong
 * @date 2024-07-09
 */
@RestController
@RequestMapping("/lpg/gasbottlefiles")
public class TLpgGasBottleFilesController extends BaseController
{
    @Autowired
    private ITLpgGasBottleFilesService tLpgGasBottleFilesService;

    /**
     * 查询液化石油气-气瓶档案列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        startPage();
        List<TLpgGasBottleFiles> list = tLpgGasBottleFilesService.selectTLpgGasBottleFilesList(tLpgGasBottleFiles);
        return getDataTable(list);
    }

    /**
     * 导出液化石油气-气瓶档案列表
     */
    @Log(title = "液化石油气-气瓶档案", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        List<TLpgGasBottleFiles> list = tLpgGasBottleFilesService.exportTLpgGasBottleFilesList(tLpgGasBottleFiles);
        ExcelUtil<TLpgGasBottleFiles> util = new ExcelUtil<>(TLpgGasBottleFiles.class);
        return util.exportExcel(list, "液化石油气-气瓶档案数据");
    }

    /**
     * 获取液化石油气-气瓶档案详细信息
     */
    @GetMapping(value = "/{fGasBottleFilesId}")
    public AjaxResult getInfo(@PathVariable("fGasBottleFilesId") Long fGasBottleFilesId)
    {
        return AjaxResult.success(tLpgGasBottleFilesService.selectTLpgGasBottleFilesById(fGasBottleFilesId));
    }

    /**
     * 新增液化石油气-气瓶档案
     */
    @Log(title = "液化石油气-气瓶档案", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        return toAjax(tLpgGasBottleFilesService.insertTLpgGasBottleFiles(tLpgGasBottleFiles));
    }

    /**
     * 修改液化石油气-气瓶档案
     */
    @Log(title = "液化石油气-气瓶档案", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLpgGasBottleFiles tLpgGasBottleFiles)
    {
        return toAjax(tLpgGasBottleFilesService.updateTLpgGasBottleFiles(tLpgGasBottleFiles));
    }

    /**
     * 删除液化石油气-气瓶档案
     */
    @Log(title = "液化石油气-气瓶档案", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fGasBottleFilesIds}")
    public AjaxResult remove(@PathVariable Long[] fGasBottleFilesIds)
    {
        return toAjax(tLpgGasBottleFilesService.deleteTLpgGasBottleFilesByIds(fGasBottleFilesIds));
    }

    /**
     * 模版下载
     * @return r
     */
    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TLpgGasBottleFiles> util = new ExcelUtil<>(TLpgGasBottleFiles.class);
        return util.importTemplateExcel("气瓶档案数据");
    }

    /**
     * 文件导入
     * @param file f
     * @param updateSupport u
     * @return r
     * @throws Exception r
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport, HttpServletResponse response) throws Exception
    {

        ExcelUtil<TLpgGasBottleFiles> util = new ExcelUtil<>(TLpgGasBottleFiles.class);
        List<TLpgGasBottleFiles> XmbhList = util.importExcel(file.getInputStream());

        return tLpgGasBottleFilesService.importLpgGasBottleFilesInfo(XmbhList, updateSupport, response);
    }

}
