package com.zehong.web.controller.lpgRegulation;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.vo.TLpgDeliveryRecordImportVo;
import org.aspectj.weaver.loadtime.Aj;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TLpgDeliveryRecord;
import com.zehong.system.service.ITLpgDeliveryRecordService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油配送记录Controller
 * 
 * @author zehong
 * @date 2024-07-22
 */
@RestController
@RequestMapping("/lpg/record")
public class TLpgDeliveryRecordController extends BaseController
{
    @Autowired
    private ITLpgDeliveryRecordService tLpgDeliveryRecordService;

    /**
     * 查询液化石油配送记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        startPage();
        List<TLpgDeliveryRecord> list = tLpgDeliveryRecordService.selectTLpgDeliveryRecordList(tLpgDeliveryRecord);
        return getDataTable(list);
    }

    /**
     * 导出液化石油配送记录列表
     */
    @Log(title = "液化石油配送记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        List<TLpgDeliveryRecord> list = tLpgDeliveryRecordService.selectTLpgDeliveryRecordList(tLpgDeliveryRecord);
        ExcelUtil<TLpgDeliveryRecord> util = new ExcelUtil<TLpgDeliveryRecord>(TLpgDeliveryRecord.class);
        return util.exportExcel(list, "液化石油配送记录数据");
    }

    /**
     * 模版下载
     * @return r
     */
    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TLpgDeliveryRecordImportVo> util = new ExcelUtil<>(TLpgDeliveryRecordImportVo.class);
        return util.importTemplateExcel("配送记录数据");
    }

    /**
     * 文件导入- 只支持 企业端导入
     * @param file f
     * @param updateSupport u
     * @return r
     * @throws Exception r
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport, HttpServletResponse response) throws Exception
    {

        if(!isEnterprise()) {
            return AjaxResult.error("只支持 企业端导入！！！");
        }

        ExcelUtil<TLpgDeliveryRecordImportVo> util = new ExcelUtil<>(TLpgDeliveryRecordImportVo.class);
        List<TLpgDeliveryRecordImportVo> XmbhList = util.importExcel(file.getInputStream());

        String deptId = SecurityUtils.getLoginUser().getUser().getDeptId();
        HashMap<String, Object> map = tLpgDeliveryRecordService.importLpgDelivertyRecordInfo(XmbhList, updateSupport, deptId, response);
        return AjaxResult.success(map);
    }


    /**
     * 判断是否为企业
     * @return r
     */
    private boolean isEnterprise(){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<String> roleKeys = roles.stream().map(item -> item.getRoleKey()).collect(Collectors.toList());
        return roleKeys.contains("qy");
    }



    /**
     * 获取液化石油配送记录详细信息
     */
    @GetMapping(value = "/{deliveryRecordId}")
    public AjaxResult getInfo(@PathVariable("deliveryRecordId") Long deliveryRecordId)
    {
        return AjaxResult.success(tLpgDeliveryRecordService.selectTLpgDeliveryRecordById(deliveryRecordId));
    }

    /**
     * 新增液化石油配送记录
     */
    @Log(title = "液化石油配送记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        return toAjax(tLpgDeliveryRecordService.insertTLpgDeliveryRecord(tLpgDeliveryRecord));
    }

    /**
     * 修改液化石油配送记录
     */
    @Log(title = "液化石油配送记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLpgDeliveryRecord tLpgDeliveryRecord)
    {
        return toAjax(tLpgDeliveryRecordService.updateTLpgDeliveryRecord(tLpgDeliveryRecord));
    }

    /**
     * 删除液化石油配送记录
     */
    @Log(title = "液化石油配送记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deliveryRecordIds}")
    public AjaxResult remove(@PathVariable Long[] deliveryRecordIds)
    {
        return toAjax(tLpgDeliveryRecordService.deleteTLpgDeliveryRecordByIds(deliveryRecordIds));
    }
}
