package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TGasUserInfo;
import com.zehong.system.domain.TSafeCheckRecord;
import com.zehong.system.domain.TTaskRecord;
import com.zehong.system.service.ITGasUserInfoService;
import com.zehong.system.service.ITSafeCheckRecordService;
import com.zehong.system.service.ITTaskRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 安检记录Controller
 *
 * @author zehong
 * @date 2023-08-21
 */
@RestController
@RequestMapping("/safe/record")
public class TSafeCheckRecordController extends BaseController
{
    @Autowired
    private ITSafeCheckRecordService tSafeCheckRecordService;

    @Autowired
    private ITGasUserInfoService tGasUserInfoService;
    @Autowired
    private ITTaskRecordService tTaskRecordService;
    /**
     * 查询安检记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSafeCheckRecord tSafeCheckRecord)
    {
        startPage();
        List<TSafeCheckRecord> list = tSafeCheckRecordService.selectTSafeCheckRecordList(tSafeCheckRecord);
        return getDataTable(list);
    }

    /**
     * 导出安检记录列表
     */
    @Log(title = "安检记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSafeCheckRecord tSafeCheckRecord)
    {
        List<TSafeCheckRecord> list = tSafeCheckRecordService.selectTSafeCheckRecordList(tSafeCheckRecord);
        ExcelUtil<TSafeCheckRecord> util = new ExcelUtil<TSafeCheckRecord>(TSafeCheckRecord.class);
        return util.exportExcel(list, "安检记录数据");
    }

    /**
     * 获取安检记录详细信息
     */
    @GetMapping(value = "/{safeCheckId}")
    public AjaxResult getInfo(@PathVariable("safeCheckId") Long safeCheckId)
    {
        return AjaxResult.success(tSafeCheckRecordService.selectTSafeCheckRecordById(safeCheckId));
    }

    /**
     * 微信小程序 获取安检记录详细信息
     * @param safeCheckId
     * @return
     */
    @GetMapping("/selectGet")
    public AjaxResult selectGetInfo(Long safeCheckId){
        TSafeCheckRecord tSafeCheckRecord = tSafeCheckRecordService.selectTSafeCheckRecordById(safeCheckId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tAirChargeRecord", tSafeCheckRecord);
        return ajax;
    }

    /**
     * 新增安检记录
     */
    @Log(title = "安检记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSafeCheckRecord tSafeCheckRecord)
    {
        return toAjax(tSafeCheckRecordService.insertTSafeCheckRecord(tSafeCheckRecord));
    }


    /**
     * 安检记录添加 微信小程序调用接口
     */
    @PostMapping("/addInfo")
    public AjaxResult addInfo(@RequestBody TSafeCheckRecord tSafeCheckRecord) throws ParseException {
//        DateFormat fmt =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

//        Date date = fmt.parse(tSafeCheckRecord.getSafeCheckDates());
        //设置安检时间
        tSafeCheckRecord.setSafeCheckDate(new Date());
        //查询用户信息
        TGasUserInfo tGasUserInfo1 = tGasUserInfoService.selectTGasUserInfoById(tSafeCheckRecord.getGasUserId());

        //设置燃气用户末次配送时间
        TGasUserInfo tGasUserInfo=new TGasUserInfo();
        tGasUserInfo.setGasUserId(tSafeCheckRecord.getGasUserId());
        tGasUserInfo.setLastDeliveryDate(new Date());
        //累计次数+1
        tGasUserInfo.setTotalCheckNum(tGasUserInfo1.getTotalCheckNum()+1);
        tGasUserInfoService.updateTGasUserInfo(tGasUserInfo);

        //设置任务记录信息
        TTaskRecord tTaskRecord=new TTaskRecord();
        //操作人id
        tTaskRecord.setOperator(Long.valueOf(tSafeCheckRecord.getSafeCheckPerson()));
        //安检记录添加
        tSafeCheckRecordService.insertTSafeCheckRecord(tSafeCheckRecord);
        //工序
        tTaskRecord.setProcessesName("2");
        tTaskRecord.setCreateTime(new Date());
        tTaskRecord.setProcessesRelationId(tSafeCheckRecord.getSafeCheckId());
        //任务记录表信息添加
//        tTaskRecordService.insertTTaskRecord(tTaskRecord);
        return toAjax( tTaskRecordService.insertTTaskRecord(tTaskRecord));
    }


    /**
     * 修改安检记录
     */
    @Log(title = "安检记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSafeCheckRecord tSafeCheckRecord)
    {
        return toAjax(tSafeCheckRecordService.updateTSafeCheckRecord(tSafeCheckRecord));
    }

    /**
     * 删除安检记录
     */
    @Log(title = "安检记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{safeCheckIds}")
    public AjaxResult remove(@PathVariable Long[] safeCheckIds)
    {
        return toAjax(tSafeCheckRecordService.deleteTSafeCheckRecordByIds(safeCheckIds));
    }
}
