package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TPractitionerInfo;
import com.zehong.system.service.ITPractitionerInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 从业人员信息Controller
 *
 * @author zehong
 * @date 2023-08-16
 */
@RestController
@RequestMapping("/practitioner/info")
public class TPractitionerInfoController extends BaseController
{
    @Autowired
    private ITPractitionerInfoService tPractitionerInfoService;

    /**
     * 查询从业人员信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPractitionerInfo tPractitionerInfo)
    {
        startPage();
        List<TPractitionerInfo> list = tPractitionerInfoService.selectTPractitionerInfoList(tPractitionerInfo);
        return getDataTable(list);
    }

    @GetMapping("/practitionerInfoList")
    public AjaxResult practitionerInfoList(TPractitionerInfo tPractitionerInfo)
    {
        List<TPractitionerInfo> list = tPractitionerInfoService.selectTPractitionerInfoList(tPractitionerInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出从业人员信息列表
     */
    @Log(title = "从业人员信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPractitionerInfo tPractitionerInfo)
    {
        List<TPractitionerInfo> list = tPractitionerInfoService.selectTPractitionerInfoList(tPractitionerInfo);
        ExcelUtil<TPractitionerInfo> util = new ExcelUtil<TPractitionerInfo>(TPractitionerInfo.class);
        return util.exportExcel(list, "从业人员信息数据");
    }

    /**
     * 获取从业人员信息详细信息
     */
    @GetMapping(value = "/{practitionerId}")
    public AjaxResult getInfo(@PathVariable("practitionerId") Long practitionerId)
    {
        return AjaxResult.success(tPractitionerInfoService.selectTPractitionerInfoById(practitionerId));
    }

    @GetMapping(value = "/getInfo")
    public AjaxResult getInfos(TPractitionerInfo tPractitionerInfo)
    {
        return AjaxResult.success(tPractitionerInfoService.selectTPractitionerInfoById(tPractitionerInfo.getPractitionerId()));
    }

    /**
     * 新增从业人员信息
     */
    @Log(title = "从业人员信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPractitionerInfo tPractitionerInfo)
    {
        //设置密码加密
        tPractitionerInfo.setPassword(SecurityUtils.encryptPassword(tPractitionerInfo.getPassword()));
        return toAjax(tPractitionerInfoService.insertTPractitionerInfo(tPractitionerInfo));
    }

    /**
     * 修改从业人员信息
     */
    @Log(title = "从业人员信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPractitionerInfo tPractitionerInfo)
    {
        //设置密码加密
        tPractitionerInfo.setPassword(SecurityUtils.encryptPassword(tPractitionerInfo.getPassword()));
        return toAjax(tPractitionerInfoService.updateTPractitionerInfo(tPractitionerInfo));
    }


    @RequestMapping("/updatePractitionerInfo")
    public AjaxResult updatePractitionerInfo(TPractitionerInfo tPractitionerInfo){
        String pass = SecurityUtils.encryptPassword(tPractitionerInfo.getPassword());
        tPractitionerInfo.setPassword(pass);
        return toAjax(tPractitionerInfoService.updateTPractitionerInfo(tPractitionerInfo));
    }


    /**
     * 删除从业人员信息
     */
    @Log(title = "从业人员信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{practitionerIds}")
    public AjaxResult remove(@PathVariable Long[] practitionerIds)
    {
        return toAjax(tPractitionerInfoService.deleteTPractitionerInfoByIds(practitionerIds));
    }

    /**
     * 从业人员导入
     * @param file
     * @param updateSupport
     * @return
     * @throws Exception
     */
    @Log(title = "从业人员导入", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<TPractitionerInfo> util = new ExcelUtil<>(TPractitionerInfo.class);
        List<TPractitionerInfo> tPractitionerInfo = util.importExcel(file.getInputStream());
        String message = tPractitionerInfoService.importTPractitionerInfo(tPractitionerInfo, updateSupport);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TPractitionerInfo> util = new ExcelUtil<>(TPractitionerInfo.class);
        return util.importTemplateExcel("从业人员数据");
    }
}
